/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.textures;

import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.CubemapSide;
import graphics.glimpse.textures.InputStreamProvider;
import graphics.glimpse.textures.TextureImageSource;
import graphics.glimpse.textures.TextureType;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgraphics/glimpse/textures/TextureImageSourceBuilder;", "", "()V", "filename", "", "inputStreamProvider", "Lgraphics/glimpse/textures/InputStreamProvider;", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "build", "Lgraphics/glimpse/textures/TextureImageSource;", "buildPrepared", "profile", "Lcom/jogamp/opengl/GLProfile;", "fromInputStream", "withFilename", "BaseTextureImageSourceImpl", "Companion", "PreparedTextureImageSourceImpl", "TextureImageSourceImpl", "core"})
public final class TextureImageSourceBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlimpseLogger logger = GlimpseLogger.Companion.create(this);
    @NotNull
    private String filename = "";
    @NotNull
    private InputStreamProvider inputStreamProvider = TextureImageSourceBuilder::inputStreamProvider$lambda-0;

    @NotNull
    public final TextureImageSourceBuilder withFilename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.filename = filename;
        return this;
    }

    @NotNull
    public final TextureImageSourceBuilder fromInputStream(@NotNull InputStreamProvider inputStreamProvider) {
        Intrinsics.checkNotNullParameter((Object)inputStreamProvider, (String)"inputStreamProvider");
        this.inputStreamProvider = inputStreamProvider;
        return this;
    }

    @NotNull
    public final TextureImageSource build() {
        if (!(!StringsKt.isBlank((CharSequence)this.filename))) {
            boolean bl = false;
            String string = "Filename cannot be blank. Must call withFilename().";
            throw new IllegalStateException(string.toString());
        }
        this.logger.debug("Building image source from: '" + this.filename + "'");
        return new TextureImageSourceImpl(this.filename, this.inputStreamProvider);
    }

    @NotNull
    public final TextureImageSource buildPrepared(@NotNull GLProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!(!StringsKt.isBlank((CharSequence)this.filename))) {
            boolean $i$a$-check-TextureImageSourceBuilder$buildPrepared$22 = false;
            String $i$a$-check-TextureImageSourceBuilder$buildPrepared$22 = "Filename cannot be blank. Must call withFilename().";
            throw new IllegalStateException($i$a$-check-TextureImageSourceBuilder$buildPrepared$22.toString());
        }
        this.logger.debug("Building image source from: '" + this.filename + "'");
        InputStream inputStream = this.inputStreamProvider.createInputStream();
        if (inputStream == null) {
            boolean $i$a$-checkNotNull-TextureImageSourceBuilder$buildPrepared$inputStream$22 = false;
            String $i$a$-checkNotNull-TextureImageSourceBuilder$buildPrepared$inputStream$22 = "Texture input stream cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-TextureImageSourceBuilder$buildPrepared$inputStream$22.toString());
        }
        InputStream inputStream2 = inputStream;
        this.logger.debug("Decoding texture data: '" + this.filename + "'");
        char[] $i$a$-checkNotNull-TextureImageSourceBuilder$buildPrepared$inputStream$22 = new char[]{'.'};
        String string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.filename, (char[])$i$a$-checkNotNull-TextureImageSourceBuilder$buildPrepared$inputStream$22, (boolean)false, (int)0, (int)6, null));
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String fileType = string2;
        TextureData textureData = TextureIO.newTextureData((GLProfile)profile, (InputStream)inputStream2, (boolean)false, (String)fileType);
        this.logger.debug("Decoded texture data: " + textureData);
        Intrinsics.checkNotNullExpressionValue((Object)textureData, (String)"textureData");
        return new PreparedTextureImageSourceImpl(textureData);
    }

    private static final InputStream inputStreamProvider$lambda-0() {
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH$J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000f\u001a\u00020\u000e*\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lgraphics/glimpse/textures/TextureImageSourceBuilder$BaseTextureImageSourceImpl;", "Lgraphics/glimpse/textures/TextureImageSource;", "()V", "glTexImage2D", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "side", "Lgraphics/glimpse/textures/CubemapSide;", "withMipmaps", "", "textureType", "Lgraphics/glimpse/textures/TextureType;", "target", "", "toInt", "core"})
    private static abstract class BaseTextureImageSourceImpl
    implements TextureImageSource {
        @Override
        public final void glTexImage2D(@NotNull GlimpseAdapter gl, boolean withMipmaps) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            this.glTexImage2D(gl, TextureType.TEXTURE_2D, 3553, withMipmaps);
        }

        @Override
        public final void glTexImage2D(@NotNull GlimpseAdapter gl, @NotNull CubemapSide side, boolean withMipmaps) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.glTexImage2D(gl, TextureType.TEXTURE_CUBE_MAP, this.toInt(side), withMipmaps);
        }

        private final int toInt(CubemapSide $this$toInt) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toInt.ordinal()]) {
                case 1: {
                    n = 34069;
                    break;
                }
                case 2: {
                    n = 34070;
                    break;
                }
                case 3: {
                    n = 34071;
                    break;
                }
                case 4: {
                    n = 34072;
                    break;
                }
                case 5: {
                    n = 34073;
                    break;
                }
                case 6: {
                    n = 34074;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        protected abstract void glTexImage2D(@NotNull GlimpseAdapter var1, @NotNull TextureType var2, int var3, boolean var4);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CubemapSide.values().length];
                nArray[CubemapSide.RIGHT.ordinal()] = 1;
                nArray[CubemapSide.LEFT.ordinal()] = 2;
                nArray[CubemapSide.TOP.ordinal()] = 3;
                nArray[CubemapSide.BOTTOM.ordinal()] = 4;
                nArray[CubemapSide.FAR.ordinal()] = 5;
                nArray[CubemapSide.NEAR.ordinal()] = 6;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgraphics/glimpse/textures/TextureImageSourceBuilder$TextureImageSourceImpl;", "Lgraphics/glimpse/textures/TextureImageSourceBuilder$BaseTextureImageSourceImpl;", "filename", "", "inputStreamProvider", "Lgraphics/glimpse/textures/InputStreamProvider;", "(Ljava/lang/String;Lgraphics/glimpse/textures/InputStreamProvider;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "dispose", "", "glTexImage2D", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "textureType", "Lgraphics/glimpse/textures/TextureType;", "target", "", "withMipmaps", "", "core"})
    private static final class TextureImageSourceImpl
    extends BaseTextureImageSourceImpl {
        @NotNull
        private final String filename;
        @NotNull
        private final InputStreamProvider inputStreamProvider;
        @NotNull
        private final GlimpseLogger logger;

        public TextureImageSourceImpl(@NotNull String filename, @NotNull InputStreamProvider inputStreamProvider) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)inputStreamProvider, (String)"inputStreamProvider");
            this.filename = filename;
            this.inputStreamProvider = inputStreamProvider;
            this.logger = GlimpseLogger.Companion.create(this);
        }

        @Override
        protected void glTexImage2D(@NotNull GlimpseAdapter gl, @NotNull TextureType textureType, int target, boolean withMipmaps) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            Intrinsics.checkNotNullParameter((Object)((Object)textureType), (String)"textureType");
            InputStream inputStream = this.inputStreamProvider.createInputStream();
            if (inputStream == null) {
                boolean $i$a$-checkNotNull-TextureImageSourceBuilder$TextureImageSourceImpl$glTexImage2D$inputStream$22 = false;
                String $i$a$-checkNotNull-TextureImageSourceBuilder$TextureImageSourceImpl$glTexImage2D$inputStream$22 = "Texture input stream cannot be null";
                throw new IllegalStateException($i$a$-checkNotNull-TextureImageSourceBuilder$TextureImageSourceImpl$glTexImage2D$inputStream$22.toString());
            }
            InputStream inputStream2 = inputStream;
            this.logger.debug("Creating texture: '" + this.filename + "'");
            char[] $i$a$-checkNotNull-TextureImageSourceBuilder$TextureImageSourceImpl$glTexImage2D$inputStream$22 = new char[]{'.'};
            String string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.filename, (char[])$i$a$-checkNotNull-TextureImageSourceBuilder$TextureImageSourceImpl$glTexImage2D$inputStream$22, (boolean)false, (int)0, (int)6, null));
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            String fileType = string2;
            TextureData textureData = TextureIO.newTextureData((GLProfile)gl.getGles$core().getGLProfile(), (InputStream)inputStream2, (boolean)false, (String)fileType);
            this.logger.debug("Decoded texture data: " + textureData);
            gl.getGles$core().glTexImage2D(target, 0, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), 0, textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            textureData.destroy();
            if (withMipmaps) {
                gl.glGenerateMipmap(textureType);
            }
        }

        @Override
        public void dispose() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgraphics/glimpse/textures/TextureImageSourceBuilder$PreparedTextureImageSourceImpl;", "Lgraphics/glimpse/textures/TextureImageSourceBuilder$BaseTextureImageSourceImpl;", "textureData", "Lcom/jogamp/opengl/util/texture/TextureData;", "(Lcom/jogamp/opengl/util/texture/TextureData;)V", "dispose", "", "glTexImage2D", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "textureType", "Lgraphics/glimpse/textures/TextureType;", "target", "", "withMipmaps", "", "core"})
    private static final class PreparedTextureImageSourceImpl
    extends BaseTextureImageSourceImpl {
        @NotNull
        private final TextureData textureData;

        public PreparedTextureImageSourceImpl(@NotNull TextureData textureData) {
            Intrinsics.checkNotNullParameter((Object)textureData, (String)"textureData");
            this.textureData = textureData;
        }

        @Override
        protected void glTexImage2D(@NotNull GlimpseAdapter gl, @NotNull TextureType textureType, int target, boolean withMipmaps) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            Intrinsics.checkNotNullParameter((Object)((Object)textureType), (String)"textureType");
            gl.getGles$core().glTexImage2D(target, 0, this.textureData.getInternalFormat(), this.textureData.getWidth(), this.textureData.getHeight(), 0, this.textureData.getPixelFormat(), this.textureData.getPixelType(), this.textureData.getBuffer());
            if (withMipmaps) {
                gl.glGenerateMipmap(textureType);
            }
        }

        @Override
        public void dispose() {
            this.textureData.destroy();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphics/glimpse/textures/TextureImageSourceBuilder$Companion;", "", "()V", "getInstance", "Lgraphics/glimpse/textures/TextureImageSourceBuilder;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextureImageSourceBuilder getInstance() {
            return new TextureImageSourceBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

