/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.textures;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.CubemapSide;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.textures.TextureImageSource;
import graphics.glimpse.textures.TextureMagFilter;
import graphics.glimpse.textures.TextureMinFilter;
import graphics.glimpse.textures.TextureType;
import graphics.glimpse.textures.TextureWrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\b\u0010\u0007\u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020#H\u0002J\u0018\u0010&\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010'\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgraphics/glimpse/textures/TextureBuilderImpl;", "Lgraphics/glimpse/textures/Texture$Builder;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "_minFilter", "Lgraphics/glimpse/textures/TextureMinFilter;", "generateMipmaps", "", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "magFilter", "Lgraphics/glimpse/textures/TextureMagFilter;", "value", "minFilter", "getMinFilter", "()Lgraphics/glimpse/textures/TextureMinFilter;", "setMinFilter", "(Lgraphics/glimpse/textures/TextureMinFilter;)V", "params", "", "Lgraphics/glimpse/textures/TextureBuilderImpl$TextureParams;", "wrapS", "Lgraphics/glimpse/textures/TextureWrap;", "wrapT", "addCubemapTexture", "side", "Lgraphics/glimpse/textures/CubemapSide;", "source", "Lgraphics/glimpse/textures/TextureImageSource;", "addTexture", "build", "", "Lgraphics/glimpse/textures/Texture;", "glTexImage", "", "textureParams", "resetState", "setTextureFilter", "setTextureWrap", "TextureImpl", "TextureParams", "core"})
public final class TextureBuilderImpl
implements Texture.Builder {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;
    @NotNull
    private final List<TextureParams> params;
    @Nullable
    private TextureMinFilter _minFilter;
    @NotNull
    private TextureMagFilter magFilter;
    @NotNull
    private TextureWrap wrapS;
    @NotNull
    private TextureWrap wrapT;
    private boolean generateMipmaps;

    public TextureBuilderImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
        this.params = new ArrayList();
        this.magFilter = TextureMagFilter.LINEAR;
        this.wrapS = TextureWrap.REPEAT;
        this.wrapT = TextureWrap.REPEAT;
    }

    private final TextureMinFilter getMinFilter() {
        TextureMinFilter textureMinFilter = this._minFilter;
        if (textureMinFilter == null) {
            textureMinFilter = this.generateMipmaps ? TextureMinFilter.LINEAR_MIPMAP_LINEAR : TextureMinFilter.LINEAR;
        }
        return textureMinFilter;
    }

    private final void setMinFilter(TextureMinFilter value) {
        this._minFilter = value;
    }

    @Override
    @NotNull
    public Texture.Builder addTexture(@NotNull TextureImageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.params.add(new TextureParams(TextureType.TEXTURE_2D, null, source));
        return this;
    }

    @Override
    @NotNull
    public Texture.Builder addCubemapTexture(@NotNull CubemapSide side, @NotNull TextureImageSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.params.add(new TextureParams(TextureType.TEXTURE_CUBE_MAP, side, source));
        return this;
    }

    @Override
    @NotNull
    public Texture.Builder setTextureFilter(@NotNull TextureMinFilter minFilter, @NotNull TextureMagFilter magFilter) {
        Intrinsics.checkNotNullParameter((Object)((Object)minFilter), (String)"minFilter");
        Intrinsics.checkNotNullParameter((Object)((Object)magFilter), (String)"magFilter");
        this.setMinFilter(minFilter);
        this.magFilter = magFilter;
        return this;
    }

    @Override
    @NotNull
    public Texture.Builder setTextureWrap(@NotNull TextureWrap wrapS, @NotNull TextureWrap wrapT) {
        Intrinsics.checkNotNullParameter((Object)((Object)wrapS), (String)"wrapS");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapT), (String)"wrapT");
        this.wrapS = wrapS;
        this.wrapT = wrapT;
        return this;
    }

    @Override
    @NotNull
    public Texture.Builder generateMipmaps() {
        this.generateMipmaps = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Texture> build() {
        void $this$mapIndexedTo$iv$iv;
        Object textureParams;
        if (!(!((Collection)this.params).isEmpty())) {
            boolean $i$a$-check-TextureBuilderImpl$build$22 = false;
            String $i$a$-check-TextureBuilderImpl$build$22 = "No textures to generate";
            throw new IllegalStateException($i$a$-check-TextureBuilderImpl$build$22.toString());
        }
        int texturesCount = this.params.size();
        this.logger.debug("Generating " + texturesCount + " textures");
        int[] handles = new int[texturesCount];
        this.gl.glGenTextures(handles);
        Iterator<TextureParams> iterator = this.params.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            textureParams = iterator.next();
            this.gl.glBindTexture(((TextureParams)textureParams).getType(), handles[index]);
            this.glTexImage((TextureParams)textureParams);
            this.gl.glTexParameterFilter(((TextureParams)textureParams).getType(), this.getMinFilter(), this.magFilter);
            this.gl.glTexParameterWrap(((TextureParams)textureParams).getType(), this.wrapS, this.wrapT);
        }
        int[] $this$mapIndexed$iv = handles;
        boolean $i$f$mapIndexed = false;
        textureParams = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void handle;
            int n2 = index$iv$iv;
            index$iv$iv = n2 + 1;
            void var15_18 = item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextureImpl((int)handle, this.params.get((int)index).getType()));
        }
        List textures = (List)destination$iv$iv;
        this.resetState();
        return textures;
    }

    private final void glTexImage(TextureParams textureParams) {
        switch (WhenMappings.$EnumSwitchMapping$0[textureParams.getType().ordinal()]) {
            case 1: {
                textureParams.getSource().glTexImage2D(this.gl, this.generateMipmaps);
                break;
            }
            case 2: {
                TextureImageSource textureImageSource = textureParams.getSource();
                GlimpseAdapter glimpseAdapter = this.gl;
                CubemapSide cubemapSide = textureParams.getSide();
                if (cubemapSide == null) {
                    GlimpseAdapter glimpseAdapter2 = glimpseAdapter;
                    TextureImageSource textureImageSource2 = textureImageSource;
                    boolean bl = false;
                    String string = "Null side for cubemap texture";
                    TextureImageSource textureImageSource3 = textureImageSource2;
                    GlimpseAdapter glimpseAdapter3 = glimpseAdapter2;
                    String string2 = string;
                    throw new IllegalStateException(string2.toString());
                }
                textureImageSource.glTexImage2D(glimpseAdapter, cubemapSide, this.generateMipmaps);
            }
        }
    }

    private final void resetState() {
        this.params.clear();
        this._minFilter = null;
        this.magFilter = TextureMagFilter.LINEAR;
        this.wrapS = TextureWrap.REPEAT;
        this.wrapT = TextureWrap.REPEAT;
        this.generateMipmaps = false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgraphics/glimpse/textures/TextureBuilderImpl$TextureParams;", "", "type", "Lgraphics/glimpse/textures/TextureType;", "side", "Lgraphics/glimpse/textures/CubemapSide;", "source", "Lgraphics/glimpse/textures/TextureImageSource;", "(Lgraphics/glimpse/textures/TextureType;Lgraphics/glimpse/textures/CubemapSide;Lgraphics/glimpse/textures/TextureImageSource;)V", "getSide", "()Lgraphics/glimpse/textures/CubemapSide;", "getSource", "()Lgraphics/glimpse/textures/TextureImageSource;", "getType", "()Lgraphics/glimpse/textures/TextureType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class TextureParams {
        @NotNull
        private final TextureType type;
        @Nullable
        private final CubemapSide side;
        @NotNull
        private final TextureImageSource source;

        public TextureParams(@NotNull TextureType type, @Nullable CubemapSide side, @NotNull TextureImageSource source) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.type = type;
            this.side = side;
            this.source = source;
        }

        @NotNull
        public final TextureType getType() {
            return this.type;
        }

        @Nullable
        public final CubemapSide getSide() {
            return this.side;
        }

        @NotNull
        public final TextureImageSource getSource() {
            return this.source;
        }

        @NotNull
        public final TextureType component1() {
            return this.type;
        }

        @Nullable
        public final CubemapSide component2() {
            return this.side;
        }

        @NotNull
        public final TextureImageSource component3() {
            return this.source;
        }

        @NotNull
        public final TextureParams copy(@NotNull TextureType type, @Nullable CubemapSide side, @NotNull TextureImageSource source) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new TextureParams(type, side, source);
        }

        public static /* synthetic */ TextureParams copy$default(TextureParams textureParams, TextureType textureType, CubemapSide cubemapSide, TextureImageSource textureImageSource, int n, Object object) {
            if ((n & 1) != 0) {
                textureType = textureParams.type;
            }
            if ((n & 2) != 0) {
                cubemapSide = textureParams.side;
            }
            if ((n & 4) != 0) {
                textureImageSource = textureParams.source;
            }
            return textureParams.copy(textureType, cubemapSide, textureImageSource);
        }

        @NotNull
        public String toString() {
            return "TextureParams(type=" + this.type + ", side=" + this.side + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + (this.side == null ? 0 : this.side.hashCode());
            result = result * 31 + this.source.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureParams)) {
                return false;
            }
            TextureParams textureParams = (TextureParams)other;
            if (this.type != textureParams.type) {
                return false;
            }
            if (this.side != textureParams.side) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)textureParams.source);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgraphics/glimpse/textures/TextureBuilderImpl$TextureImpl;", "Lgraphics/glimpse/textures/Texture;", "handle", "", "type", "Lgraphics/glimpse/textures/TextureType;", "(ILgraphics/glimpse/textures/TextureType;)V", "getHandle", "()I", "component1", "component2", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "useAtIndex", "textureIndex", "core"})
    public static final class TextureImpl
    implements Texture {
        private final int handle;
        @NotNull
        private final TextureType type;

        public TextureImpl(int handle, @NotNull TextureType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.handle = handle;
            this.type = type;
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void useAtIndex(@NotNull GlimpseAdapter gl, int textureIndex) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glActiveTexture(textureIndex);
            gl.glBindTexture(this.type, this.getHandle());
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            int[] nArray = new int[]{this.getHandle()};
            int[] handles = nArray;
            gl.glDeleteTextures(handles);
        }

        public final int component1() {
            return this.getHandle();
        }

        private final TextureType component2() {
            return this.type;
        }

        @NotNull
        public final TextureImpl copy(int handle, @NotNull TextureType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new TextureImpl(handle, type);
        }

        public static /* synthetic */ TextureImpl copy$default(TextureImpl textureImpl, int n, TextureType textureType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = textureImpl.getHandle();
            }
            if ((n2 & 2) != 0) {
                textureType = textureImpl.type;
            }
            return textureImpl.copy(n, textureType);
        }

        @NotNull
        public String toString() {
            return "TextureImpl(handle=" + this.getHandle() + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.getHandle());
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureImpl)) {
                return false;
            }
            TextureImpl textureImpl = (TextureImpl)other;
            if (this.getHandle() != textureImpl.getHandle()) {
                return false;
            }
            return this.type == textureImpl.type;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextureType.values().length];
            nArray[TextureType.TEXTURE_2D.ordinal()] = 1;
            nArray[TextureType.TEXTURE_CUBE_MAP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

