/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.shaders;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.shaders.Program;
import graphics.glimpse.shaders.Shader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgraphics/glimpse/shaders/ProgramBuilderImpl;", "Lgraphics/glimpse/shaders/Program$Builder;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "fragmentShaderHandle", "", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "vertexShaderHandle", "build", "Lgraphics/glimpse/shaders/Program;", "cleanUpAfterError", "", "handle", "linkProgram", "validateProgram", "withFragmentShader", "fragmentShader", "Lgraphics/glimpse/shaders/Shader;", "withVertexShader", "vertexShader", "ProgramImpl", "core"})
public final class ProgramBuilderImpl
implements Program.Builder {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;
    private int vertexShaderHandle;
    private int fragmentShaderHandle;

    public ProgramBuilderImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    @Override
    @NotNull
    public Program.Builder withVertexShader(@NotNull Shader vertexShader) {
        Intrinsics.checkNotNullParameter((Object)vertexShader, (String)"vertexShader");
        this.vertexShaderHandle = vertexShader.getHandle();
        return this;
    }

    @Override
    @NotNull
    public Program.Builder withFragmentShader(@NotNull Shader fragmentShader) {
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        this.fragmentShaderHandle = fragmentShader.getHandle();
        return this;
    }

    @Override
    @NotNull
    public Program build() {
        if (!(this.vertexShaderHandle != 0)) {
            boolean $i$a$-check-ProgramBuilderImpl$build$32 = false;
            String $i$a$-check-ProgramBuilderImpl$build$32 = "Vertex shader not set";
            throw new IllegalStateException($i$a$-check-ProgramBuilderImpl$build$32.toString());
        }
        if (!(this.fragmentShaderHandle != 0)) {
            boolean bl = false;
            String string = "Fragment shader not set";
            throw new IllegalStateException(string.toString());
        }
        this.logger.debug(StringsKt.trimMargin$default((String)("\n                |Linking program with:\n                | - vertex shader " + this.vertexShaderHandle + "\n                | - fragment shader " + this.fragmentShaderHandle + "\n            "), null, (int)1, null));
        int handle = this.gl.glCreateProgram();
        this.gl.glAttachShader(handle, this.vertexShaderHandle);
        this.gl.glAttachShader(handle, this.fragmentShaderHandle);
        this.linkProgram(handle);
        this.validateProgram(handle);
        return new ProgramImpl(handle, this.vertexShaderHandle, this.fragmentShaderHandle);
    }

    private final void linkProgram(int handle) {
        this.gl.glLinkProgram(handle);
        if (!this.gl.glGetProgramLinkStatus(handle)) {
            String programInfoLog = this.gl.glGetProgramInfoLog(handle);
            this.logger.error("Program linking failed:\n" + programInfoLog + "\nCleaning up");
            this.cleanUpAfterError(handle);
            throw new IllegalStateException("Program linking failed:\n" + programInfoLog);
        }
    }

    private final void validateProgram(int handle) {
        this.gl.glValidateProgram(handle);
        if (!this.gl.glGetProgramValidateStatus(handle)) {
            String programInfoLog = this.gl.glGetProgramInfoLog(handle);
            this.logger.error("Program validation failed:\n" + programInfoLog + "\nCleaning up");
            this.cleanUpAfterError(handle);
            throw new IllegalStateException("Program validation failed:\n" + programInfoLog);
        }
    }

    private final void cleanUpAfterError(int handle) {
        this.gl.glDeleteProgram(handle);
        this.gl.glDeleteShader(this.vertexShaderHandle);
        this.gl.glDeleteShader(this.fragmentShaderHandle);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgraphics/glimpse/shaders/ProgramBuilderImpl$ProgramImpl;", "Lgraphics/glimpse/shaders/Program;", "handle", "", "vertexShaderHandle", "fragmentShaderHandle", "(III)V", "getHandle", "()I", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "component1", "component2", "component3", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "use", "core"})
    private static final class ProgramImpl
    implements Program {
        private final int handle;
        private final int vertexShaderHandle;
        private final int fragmentShaderHandle;
        @NotNull
        private final GlimpseLogger logger;

        public ProgramImpl(int handle, int vertexShaderHandle, int fragmentShaderHandle) {
            this.handle = handle;
            this.vertexShaderHandle = vertexShaderHandle;
            this.fragmentShaderHandle = fragmentShaderHandle;
            this.logger = GlimpseLogger.Companion.create(this);
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void use(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glUseProgram(this.getHandle());
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glDeleteProgram(this.getHandle());
            gl.glDeleteShader(this.vertexShaderHandle);
            gl.glDeleteShader(this.fragmentShaderHandle);
            if (!gl.glGetProgramDeleteStatus(this.getHandle())) {
                String shaderInfoLog = gl.glGetProgramInfoLog(this.getHandle());
                this.logger.error("Program deletion failed:\n" + shaderInfoLog);
                throw new IllegalStateException("Program deletion failed:\n" + shaderInfoLog);
            }
        }

        public final int component1() {
            return this.getHandle();
        }

        private final int component2() {
            return this.vertexShaderHandle;
        }

        private final int component3() {
            return this.fragmentShaderHandle;
        }

        @NotNull
        public final ProgramImpl copy(int handle, int vertexShaderHandle, int fragmentShaderHandle) {
            return new ProgramImpl(handle, vertexShaderHandle, fragmentShaderHandle);
        }

        public static /* synthetic */ ProgramImpl copy$default(ProgramImpl programImpl, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = programImpl.getHandle();
            }
            if ((n4 & 2) != 0) {
                n2 = programImpl.vertexShaderHandle;
            }
            if ((n4 & 4) != 0) {
                n3 = programImpl.fragmentShaderHandle;
            }
            return programImpl.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ProgramImpl(handle=" + this.getHandle() + ", vertexShaderHandle=" + this.vertexShaderHandle + ", fragmentShaderHandle=" + this.fragmentShaderHandle + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.getHandle());
            result = result * 31 + Integer.hashCode(this.vertexShaderHandle);
            result = result * 31 + Integer.hashCode(this.fragmentShaderHandle);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProgramImpl)) {
                return false;
            }
            ProgramImpl programImpl = (ProgramImpl)other;
            if (this.getHandle() != programImpl.getHandle()) {
                return false;
            }
            if (this.vertexShaderHandle != programImpl.vertexShaderHandle) {
                return false;
            }
            return this.fragmentShaderHandle == programImpl.fragmentShaderHandle;
        }
    }
}

