/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.shaders;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.shaders.Program;
import graphics.glimpse.shaders.ProgramExecutor;
import graphics.glimpse.types.Mat2;
import graphics.glimpse.types.Mat3;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0002\u0010\u0015\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0004J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0015H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0016H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0017H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0018H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0019H\u0004J+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0004\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0004\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0004\u00a2\u0006\u0002\u0010\u001eJ+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0004\u00a2\u0006\u0002\u0010\u001fJ+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0004\u00a2\u0006\u0002\u0010 J+\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0004\u00a2\u0006\u0002\u0010!J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\"H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020#H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020$H\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\tH\u0004J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020%H\u0004J \u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0004J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgraphics/glimpse/shaders/BaseProgramExecutor;", "T", "Lgraphics/glimpse/shaders/ProgramExecutor;", "program", "Lgraphics/glimpse/shaders/Program;", "(Lgraphics/glimpse/shaders/Program;)V", "attributeLocations", "", "", "", "uniformLocations", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "getAttributeLocation", "name", "getUniformLocation", "glUniform", "value", "Lgraphics/glimpse/types/Mat2;", "Lgraphics/glimpse/types/Mat3;", "Lgraphics/glimpse/types/Mat4;", "Lgraphics/glimpse/types/Vec2;", "Lgraphics/glimpse/types/Vec3;", "Lgraphics/glimpse/types/Vec4;", "values", "", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Mat2;)V", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Mat3;)V", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Mat4;)V", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Vec2;)V", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Vec3;)V", "(Lgraphics/glimpse/GlimpseAdapter;Ljava/lang/String;[Lgraphics/glimpse/types/Vec4;)V", "", "", "", "", "glVertexAttribPointer", "location", "vectorSize", "useProgram", "core"})
public abstract class BaseProgramExecutor<T>
implements ProgramExecutor<T> {
    @NotNull
    private final Program program;
    @NotNull
    private final Map<String, Integer> uniformLocations;
    @NotNull
    private final Map<String, Integer> attributeLocations;

    public BaseProgramExecutor(@NotNull Program program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        this.program = program;
        this.uniformLocations = new LinkedHashMap();
        this.attributeLocations = new LinkedHashMap();
    }

    @Override
    public void useProgram(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.program.use(gl);
    }

    protected final int getUniformLocation(@NotNull GlimpseAdapter gl, @NotNull String name) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Integer> $this$getOrPut$iv = this.uniformLocations;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = gl.glGetUniformLocation(this.program.getHandle(), name);
            $this$getOrPut$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    protected final int getAttributeLocation(@NotNull GlimpseAdapter gl, @NotNull String name) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Integer> $this$getOrPut$iv = this.attributeLocations;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = gl.glGetAttributeLocation(this.program.getHandle(), name);
            $this$getOrPut$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        gl.glUniform(this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length));
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull float[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        gl.glUniform(this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length));
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec2 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec2[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        gl.glUniform(this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length));
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec3 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec3[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        gl.glUniform(this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length));
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec4 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        gl.glUniform(this.getUniformLocation(gl, name), value);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Vec4[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        gl.glUniform(this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length));
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat2 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Mat2[] mat2Array = new Mat2[]{value};
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), mat2Array, false, 4, null);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat2[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length), false, 4, null);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat3 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Mat3[] mat3Array = new Mat3[]{value};
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), mat3Array, false, 4, null);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat3[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length), false, 4, null);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat4 value) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Mat4[] mat4Array = new Mat4[]{value};
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), mat4Array, false, 4, null);
    }

    protected final void glUniform(@NotNull GlimpseAdapter gl, @NotNull String name, @NotNull Mat4[] values) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        GlimpseAdapter.glUniform$default(gl, this.getUniformLocation(gl, name), Arrays.copyOf(values, values.length), false, 4, null);
    }

    protected final void glVertexAttribPointer(@NotNull GlimpseAdapter gl, int location, int vectorSize) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        GlimpseAdapter.glVertexAttribPointer$default(gl, location, vectorSize, false, 0, 0, 28, null);
    }

    @Override
    @Deprecated(message="Use dispose(GlimpseAdapter) instead")
    public void dispose() {
        this.uniformLocations.clear();
        this.attributeLocations.clear();
    }

    @Override
    public void dispose(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.uniformLocations.clear();
        this.attributeLocations.clear();
        this.program.dispose(gl);
    }
}

