/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.meshes;

import graphics.glimpse.DrawingMode;
import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.buffers.Buffer;
import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.meshes.ArrayMeshData;
import graphics.glimpse.meshes.Mesh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgraphics/glimpse/meshes/MeshFactoryImpl;", "Lgraphics/glimpse/meshes/Mesh$Factory;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "bufferFactory", "Lgraphics/glimpse/buffers/Buffer$Factory;", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "createMesh", "Lgraphics/glimpse/meshes/Mesh;", "arrayMeshData", "Lgraphics/glimpse/meshes/ArrayMeshData;", "ArrayMesh", "core"})
public final class MeshFactoryImpl
implements Mesh.Factory {
    @NotNull
    private final GlimpseLogger logger;
    @NotNull
    private final Buffer.Factory bufferFactory;

    public MeshFactoryImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.logger = GlimpseLogger.Companion.create(this);
        this.bufferFactory = Buffer.Factory.Companion.newInstance(gl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Mesh createMesh(@NotNull ArrayMeshData arrayMeshData) {
        void $this$createMesh_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)arrayMeshData, (String)"arrayMeshData");
        this.logger.debug("Creating array mesh with " + arrayMeshData.getVertexCount() + " vertices");
        ArrayMeshData arrayMeshData2 = arrayMeshData;
        int n = arrayMeshData.getVertexCount();
        boolean bl = false;
        FloatBufferData[] floatBufferDataArray = new FloatBufferData[]{$this$createMesh_u24lambda_u2d0.getPositionsData(), $this$createMesh_u24lambda_u2d0.getTexCoordsData(), $this$createMesh_u24lambda_u2d0.getNormalsData(), $this$createMesh_u24lambda_u2d0.getTangentsData(), $this$createMesh_u24lambda_u2d0.getBitangentsData()};
        List<Buffer> list = this.bufferFactory.createArrayBuffers(floatBufferDataArray);
        List<Buffer> list2 = list;
        int n2 = n;
        return new ArrayMesh(n2, list2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lgraphics/glimpse/meshes/MeshFactoryImpl$ArrayMesh;", "Lgraphics/glimpse/meshes/Mesh;", "vertexCount", "", "buffers", "", "Lgraphics/glimpse/buffers/Buffer;", "(ILjava/util/List;)V", "getBuffers", "()Ljava/util/List;", "getVertexCount", "()I", "component1", "component2", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "draw", "equals", "", "other", "", "hashCode", "toString", "", "useBuffer", "bufferIndex", "core"})
    private static final class ArrayMesh
    implements Mesh {
        private final int vertexCount;
        @NotNull
        private final List<Buffer> buffers;

        public ArrayMesh(int vertexCount, @NotNull List<? extends Buffer> buffers) {
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            this.vertexCount = vertexCount;
            this.buffers = buffers;
        }

        @Override
        public int getVertexCount() {
            return this.vertexCount;
        }

        @Override
        @NotNull
        public List<Buffer> getBuffers() {
            return this.buffers;
        }

        @Override
        public void useBuffer(@NotNull GlimpseAdapter gl, int bufferIndex) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            this.getBuffers().get(bufferIndex).use(gl);
        }

        @Override
        public void draw(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            GlimpseAdapter.glDrawArrays$default(gl, DrawingMode.TRIANGLES, this.getVertexCount(), 0, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            Iterable iterable = this.getBuffers();
            GlimpseAdapter glimpseAdapter = gl;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Buffer buffer = (Buffer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getHandle());
            }
            glimpseAdapter.glDeleteBuffers(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
        }

        public final int component1() {
            return this.getVertexCount();
        }

        @NotNull
        public final List<Buffer> component2() {
            return this.getBuffers();
        }

        @NotNull
        public final ArrayMesh copy(int vertexCount, @NotNull List<? extends Buffer> buffers) {
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            return new ArrayMesh(vertexCount, buffers);
        }

        public static /* synthetic */ ArrayMesh copy$default(ArrayMesh arrayMesh, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = arrayMesh.getVertexCount();
            }
            if ((n2 & 2) != 0) {
                list = arrayMesh.getBuffers();
            }
            return arrayMesh.copy(n, list);
        }

        @NotNull
        public String toString() {
            return "ArrayMesh(vertexCount=" + this.getVertexCount() + ", buffers=" + this.getBuffers() + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.getVertexCount());
            result = result * 31 + ((Object)this.getBuffers()).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArrayMesh)) {
                return false;
            }
            ArrayMesh arrayMesh = (ArrayMesh)other;
            if (this.getVertexCount() != arrayMesh.getVertexCount()) {
                return false;
            }
            return Intrinsics.areEqual(this.getBuffers(), arrayMesh.getBuffers());
        }
    }
}

