/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.meshes;

import graphics.glimpse.buffers.BufferDataExtensionsKt;
import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.meshes.ArrayMeshData;
import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgraphics/glimpse/meshes/MeshDataBuilder;", "", "()V", "normals", "", "Lgraphics/glimpse/types/Vec3;", "positions", "texCoords", "Lgraphics/glimpse/types/Vec2;", "triangles", "Lgraphics/glimpse/meshes/MeshDataBuilder$Triangle;", "addFace", "indices", "", "Lgraphics/glimpse/meshes/MeshDataBuilder$FaceVertex;", "addNormal", "normal", "coordinates", "", "addTextureCoordinates", "addVertex", "vertexPos", "buildArrayMeshData", "Lgraphics/glimpse/meshes/ArrayMeshData;", "Companion", "FaceVertex", "Triangle", "core"})
public final class MeshDataBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Vec3> positions = new ArrayList();
    @NotNull
    private final List<Vec2> texCoords = new ArrayList();
    @NotNull
    private final List<Vec3> normals = new ArrayList();
    @NotNull
    private final List<Triangle> triangles = new ArrayList();
    private static final int TRIANGLE_VERTICES = 3;

    @NotNull
    public final MeshDataBuilder addVertex(@NotNull Vec3 vertexPos) {
        Intrinsics.checkNotNullParameter((Object)vertexPos, (String)"vertexPos");
        this.positions.add(vertexPos);
        return this;
    }

    @NotNull
    public final MeshDataBuilder addVertex(@NotNull List<Float> coordinates) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return this.addVertex(Vec3.Companion.fromList(coordinates));
    }

    @NotNull
    public final MeshDataBuilder addTextureCoordinates(@NotNull Vec2 coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.texCoords.add(coordinates);
        return this;
    }

    @NotNull
    public final MeshDataBuilder addTextureCoordinates(@NotNull List<Float> coordinates) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return this.addTextureCoordinates(Vec2.Companion.fromList(coordinates));
    }

    @NotNull
    public final MeshDataBuilder addNormal(@NotNull Vec3 normal) {
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        this.normals.add(normal);
        return this;
    }

    @NotNull
    public final MeshDataBuilder addNormal(@NotNull List<Float> coordinates) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return this.addNormal(Vec3.Companion.fromList(coordinates));
    }

    @NotNull
    public final MeshDataBuilder addFace(@NotNull List<FaceVertex> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        FaceVertex p1 = (FaceVertex)CollectionsKt.first(indices);
        CollectionsKt.windowed$default((Iterable)CollectionsKt.drop((Iterable)indices, (int)1), (int)2, (int)0, (boolean)false, (Function1)((Function1)new Function1<List<? extends FaceVertex>, Boolean>(this, p1){
            final /* synthetic */ MeshDataBuilder this$0;
            final /* synthetic */ FaceVertex $p1;
            {
                this.this$0 = $receiver;
                this.$p1 = $p1;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull List<FaceVertex> $dstr$p2$p3) {
                Intrinsics.checkNotNullParameter($dstr$p2$p3, (String)"$dstr$p2$p3");
                FaceVertex p2 = $dstr$p2$p3.get(0);
                FaceVertex p3 = $dstr$p2$p3.get(1);
                return MeshDataBuilder.access$getTriangles$p(this.this$0).add(new Triangle((Vec3)MeshDataBuilder.access$getPositions$p(this.this$0).get(this.$p1.getPositionIndex()), (Vec3)MeshDataBuilder.access$getPositions$p(this.this$0).get(p2.getPositionIndex()), (Vec3)MeshDataBuilder.access$getPositions$p(this.this$0).get(p3.getPositionIndex()), (Vec2)MeshDataBuilder.access$getTexCoords$p(this.this$0).get(this.$p1.getTexCoordIndex()), (Vec2)MeshDataBuilder.access$getTexCoords$p(this.this$0).get(p2.getTexCoordIndex()), (Vec2)MeshDataBuilder.access$getTexCoords$p(this.this$0).get(p3.getTexCoordIndex()), (Vec3)MeshDataBuilder.access$getNormals$p(this.this$0).get(this.$p1.getNormalIndex()), (Vec3)MeshDataBuilder.access$getNormals$p(this.this$0).get(p2.getNormalIndex()), (Vec3)MeshDataBuilder.access$getNormals$p(this.this$0).get(p3.getNormalIndex())));
            }
        }), (int)6, null);
        return this;
    }

    @NotNull
    public final ArrayMeshData buildArrayMeshData() {
        Iterable list$iv$iv;
        Iterable list$iv$iv2;
        Vec vector;
        Iterable $this$flatMapTo$iv$iv;
        boolean $i$f$flatMapTo;
        Collection destination$iv$iv;
        boolean $i$f$flatMap;
        Iterable $this$flatMap$iv;
        Triangle triangle;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Iterable iterable = this.triangles;
        int n = this.triangles.size() * 3;
        boolean $i$f$flatMap2 = false;
        void var4_4 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            triangle = (Triangle)element$iv$iv;
            boolean bl = false;
            $this$flatMap$iv = triangle.getPositions();
            $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                vector = (Vec3)element$iv$iv2;
                boolean bl2 = false;
                list$iv$iv2 = ((Vec3)vector).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Object object = (List)destination$iv$iv2;
        $this$flatMap$iv2 = this.triangles;
        object = BufferDataExtensionsKt.toFloatBufferData((Collection)object);
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            triangle = (Triangle)element$iv$iv;
            boolean bl = false;
            $this$flatMap$iv = triangle.getTextureCoordinates();
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                vector = (Vec2)element$iv$iv2;
                boolean bl3 = false;
                list$iv$iv2 = ((Vec2)vector).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Object object2 = (List)destination$iv$iv2;
        $this$flatMap$iv2 = this.triangles;
        object2 = BufferDataExtensionsKt.toFloatBufferData((Collection)object2);
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            triangle = (Triangle)element$iv$iv;
            boolean bl = false;
            $this$flatMap$iv = triangle.getNormals();
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                vector = (Vec3)element$iv$iv2;
                boolean bl4 = false;
                list$iv$iv2 = ((Vec3)vector).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Object object3 = (List)destination$iv$iv2;
        $this$flatMap$iv2 = this.triangles;
        object3 = BufferDataExtensionsKt.toFloatBufferData((Collection)object3);
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            triangle = (Triangle)element$iv$iv;
            boolean bl = false;
            $this$flatMap$iv = triangle.getTangents();
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                vector = (Vec3)element$iv$iv2;
                boolean bl5 = false;
                list$iv$iv2 = ((Vec3)vector).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Object object4 = (List)destination$iv$iv2;
        $this$flatMap$iv2 = this.triangles;
        object4 = BufferDataExtensionsKt.toFloatBufferData((Collection)object4);
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            triangle = (Triangle)element$iv$iv;
            boolean bl = false;
            $this$flatMap$iv = triangle.getBitangents();
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                vector = (Vec3)element$iv$iv2;
                boolean bl6 = false;
                list$iv$iv2 = ((Vec3)vector).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        FloatBufferData floatBufferData = BufferDataExtensionsKt.toFloatBufferData(list);
        Object object5 = object4;
        Object object6 = object3;
        Object object7 = object2;
        Object object8 = object;
        int n2 = n;
        ArrayMeshData meshData = new ArrayMeshData(n2, (FloatBufferData)object8, (FloatBufferData)object7, (FloatBufferData)object6, (FloatBufferData)object5, floatBufferData);
        this.positions.clear();
        this.texCoords.clear();
        this.normals.clear();
        this.triangles.clear();
        return meshData;
    }

    public static final /* synthetic */ List access$getTriangles$p(MeshDataBuilder $this) {
        return $this.triangles;
    }

    public static final /* synthetic */ List access$getPositions$p(MeshDataBuilder $this) {
        return $this.positions;
    }

    public static final /* synthetic */ List access$getTexCoords$p(MeshDataBuilder $this) {
        return $this.texCoords;
    }

    public static final /* synthetic */ List access$getNormals$p(MeshDataBuilder $this) {
        return $this.normals;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lgraphics/glimpse/meshes/MeshDataBuilder$FaceVertex;", "", "positionIndex", "", "texCoordIndex", "normalIndex", "(III)V", "getNormalIndex", "()I", "getPositionIndex", "getTexCoordIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class FaceVertex {
        private final int positionIndex;
        private final int texCoordIndex;
        private final int normalIndex;

        public FaceVertex(int positionIndex, int texCoordIndex, int normalIndex) {
            this.positionIndex = positionIndex;
            this.texCoordIndex = texCoordIndex;
            this.normalIndex = normalIndex;
        }

        public final int getPositionIndex() {
            return this.positionIndex;
        }

        public final int getTexCoordIndex() {
            return this.texCoordIndex;
        }

        public final int getNormalIndex() {
            return this.normalIndex;
        }

        public final int component1() {
            return this.positionIndex;
        }

        public final int component2() {
            return this.texCoordIndex;
        }

        public final int component3() {
            return this.normalIndex;
        }

        @NotNull
        public final FaceVertex copy(int positionIndex, int texCoordIndex, int normalIndex) {
            return new FaceVertex(positionIndex, texCoordIndex, normalIndex);
        }

        public static /* synthetic */ FaceVertex copy$default(FaceVertex faceVertex, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = faceVertex.positionIndex;
            }
            if ((n4 & 2) != 0) {
                n2 = faceVertex.texCoordIndex;
            }
            if ((n4 & 4) != 0) {
                n3 = faceVertex.normalIndex;
            }
            return faceVertex.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "FaceVertex(positionIndex=" + this.positionIndex + ", texCoordIndex=" + this.texCoordIndex + ", normalIndex=" + this.normalIndex + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.positionIndex);
            result = result * 31 + Integer.hashCode(this.texCoordIndex);
            result = result * 31 + Integer.hashCode(this.normalIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FaceVertex)) {
                return false;
            }
            FaceVertex faceVertex = (FaceVertex)other;
            if (this.positionIndex != faceVertex.positionIndex) {
                return false;
            }
            if (this.texCoordIndex != faceVertex.texCoordIndex) {
                return false;
            }
            return this.normalIndex == faceVertex.normalIndex;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003Jc\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u000207H\u00d6\u0001J\t\u00108\u001a\u000209H\u00d6\u0001R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0014\u00a8\u0006:"}, d2={"Lgraphics/glimpse/meshes/MeshDataBuilder$Triangle;", "", "position1", "Lgraphics/glimpse/types/Vec3;", "position2", "position3", "texCoord1", "Lgraphics/glimpse/types/Vec2;", "texCoord2", "texCoord3", "normal1", "normal2", "normal3", "(Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec2;Lgraphics/glimpse/types/Vec2;Lgraphics/glimpse/types/Vec2;Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;)V", "bitangent", "getBitangent", "()Lgraphics/glimpse/types/Vec3;", "bitangents", "", "getBitangents", "()Ljava/util/List;", "getNormal1", "getNormal2", "getNormal3", "normals", "getNormals", "getPosition1", "getPosition2", "getPosition3", "positions", "getPositions", "tangent", "getTangent", "tangents", "getTangents", "getTexCoord1", "()Lgraphics/glimpse/types/Vec2;", "getTexCoord2", "getTexCoord3", "textureCoordinates", "getTextureCoordinates", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class Triangle {
        @NotNull
        private final Vec3 position1;
        @NotNull
        private final Vec3 position2;
        @NotNull
        private final Vec3 position3;
        @NotNull
        private final Vec2 texCoord1;
        @NotNull
        private final Vec2 texCoord2;
        @NotNull
        private final Vec2 texCoord3;
        @NotNull
        private final Vec3 normal1;
        @NotNull
        private final Vec3 normal2;
        @NotNull
        private final Vec3 normal3;
        @NotNull
        private final Vec3 tangent;
        @NotNull
        private final Vec3 bitangent;

        public Triangle(@NotNull Vec3 position1, @NotNull Vec3 position2, @NotNull Vec3 position3, @NotNull Vec2 texCoord1, @NotNull Vec2 texCoord2, @NotNull Vec2 texCoord3, @NotNull Vec3 normal1, @NotNull Vec3 normal2, @NotNull Vec3 normal3) {
            Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
            Intrinsics.checkNotNullParameter((Object)position3, (String)"position3");
            Intrinsics.checkNotNullParameter((Object)texCoord1, (String)"texCoord1");
            Intrinsics.checkNotNullParameter((Object)texCoord2, (String)"texCoord2");
            Intrinsics.checkNotNullParameter((Object)texCoord3, (String)"texCoord3");
            Intrinsics.checkNotNullParameter((Object)normal1, (String)"normal1");
            Intrinsics.checkNotNullParameter((Object)normal2, (String)"normal2");
            Intrinsics.checkNotNullParameter((Object)normal3, (String)"normal3");
            this.position1 = position1;
            this.position2 = position2;
            this.position3 = position3;
            this.texCoord1 = texCoord1;
            this.texCoord2 = texCoord2;
            this.texCoord3 = texCoord3;
            this.normal1 = normal1;
            this.normal2 = normal2;
            this.normal3 = normal3;
            Vec3 edge1 = this.position2.minus(this.position1);
            Vec3 edge2 = this.position3.minus(this.position1);
            Vec2 deltaUV1 = this.texCoord2.minus(this.texCoord1);
            Vec2 deltaUV2 = this.texCoord3.minus(this.texCoord1);
            float factor = 1.0f / (deltaUV1.getX() * deltaUV2.getY() - deltaUV2.getX() * deltaUV1.getY());
            this.tangent = edge1.times(deltaUV2.getY()).minus(edge2.times(deltaUV1.getY())).times(factor);
            this.bitangent = edge2.times(deltaUV1.getX()).minus(edge1.times(deltaUV2.getX())).times(factor);
        }

        @NotNull
        public final Vec3 getPosition1() {
            return this.position1;
        }

        @NotNull
        public final Vec3 getPosition2() {
            return this.position2;
        }

        @NotNull
        public final Vec3 getPosition3() {
            return this.position3;
        }

        @NotNull
        public final Vec2 getTexCoord1() {
            return this.texCoord1;
        }

        @NotNull
        public final Vec2 getTexCoord2() {
            return this.texCoord2;
        }

        @NotNull
        public final Vec2 getTexCoord3() {
            return this.texCoord3;
        }

        @NotNull
        public final Vec3 getNormal1() {
            return this.normal1;
        }

        @NotNull
        public final Vec3 getNormal2() {
            return this.normal2;
        }

        @NotNull
        public final Vec3 getNormal3() {
            return this.normal3;
        }

        @NotNull
        public final Vec3 getTangent() {
            return this.tangent;
        }

        @NotNull
        public final Vec3 getBitangent() {
            return this.bitangent;
        }

        @NotNull
        public final List<Vec3> getPositions() {
            Object[] objectArray = new Vec3[]{this.position1, this.position2, this.position3};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<Vec2> getTextureCoordinates() {
            Object[] objectArray = new Vec2[]{this.texCoord1, this.texCoord2, this.texCoord3};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<Vec3> getNormals() {
            Object[] objectArray = new Vec3[]{this.normal1, this.normal2, this.normal3};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<Vec3> getTangents() {
            Object[] objectArray = new Vec3[]{this.tangent, this.tangent, this.tangent};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<Vec3> getBitangents() {
            Object[] objectArray = new Vec3[]{this.bitangent, this.bitangent, this.bitangent};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final Vec3 component1() {
            return this.position1;
        }

        @NotNull
        public final Vec3 component2() {
            return this.position2;
        }

        @NotNull
        public final Vec3 component3() {
            return this.position3;
        }

        @NotNull
        public final Vec2 component4() {
            return this.texCoord1;
        }

        @NotNull
        public final Vec2 component5() {
            return this.texCoord2;
        }

        @NotNull
        public final Vec2 component6() {
            return this.texCoord3;
        }

        @NotNull
        public final Vec3 component7() {
            return this.normal1;
        }

        @NotNull
        public final Vec3 component8() {
            return this.normal2;
        }

        @NotNull
        public final Vec3 component9() {
            return this.normal3;
        }

        @NotNull
        public final Triangle copy(@NotNull Vec3 position1, @NotNull Vec3 position2, @NotNull Vec3 position3, @NotNull Vec2 texCoord1, @NotNull Vec2 texCoord2, @NotNull Vec2 texCoord3, @NotNull Vec3 normal1, @NotNull Vec3 normal2, @NotNull Vec3 normal3) {
            Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
            Intrinsics.checkNotNullParameter((Object)position3, (String)"position3");
            Intrinsics.checkNotNullParameter((Object)texCoord1, (String)"texCoord1");
            Intrinsics.checkNotNullParameter((Object)texCoord2, (String)"texCoord2");
            Intrinsics.checkNotNullParameter((Object)texCoord3, (String)"texCoord3");
            Intrinsics.checkNotNullParameter((Object)normal1, (String)"normal1");
            Intrinsics.checkNotNullParameter((Object)normal2, (String)"normal2");
            Intrinsics.checkNotNullParameter((Object)normal3, (String)"normal3");
            return new Triangle(position1, position2, position3, texCoord1, texCoord2, texCoord3, normal1, normal2, normal3);
        }

        public static /* synthetic */ Triangle copy$default(Triangle triangle, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec2 vec2, Vec2 vec22, Vec2 vec23, Vec3 vec34, Vec3 vec35, Vec3 vec36, int n, Object object) {
            if ((n & 1) != 0) {
                vec3 = triangle.position1;
            }
            if ((n & 2) != 0) {
                vec32 = triangle.position2;
            }
            if ((n & 4) != 0) {
                vec33 = triangle.position3;
            }
            if ((n & 8) != 0) {
                vec2 = triangle.texCoord1;
            }
            if ((n & 0x10) != 0) {
                vec22 = triangle.texCoord2;
            }
            if ((n & 0x20) != 0) {
                vec23 = triangle.texCoord3;
            }
            if ((n & 0x40) != 0) {
                vec34 = triangle.normal1;
            }
            if ((n & 0x80) != 0) {
                vec35 = triangle.normal2;
            }
            if ((n & 0x100) != 0) {
                vec36 = triangle.normal3;
            }
            return triangle.copy(vec3, vec32, vec33, vec2, vec22, vec23, vec34, vec35, vec36);
        }

        @NotNull
        public String toString() {
            return "Triangle(position1=" + this.position1 + ", position2=" + this.position2 + ", position3=" + this.position3 + ", texCoord1=" + this.texCoord1 + ", texCoord2=" + this.texCoord2 + ", texCoord3=" + this.texCoord3 + ", normal1=" + this.normal1 + ", normal2=" + this.normal2 + ", normal3=" + this.normal3 + ")";
        }

        public int hashCode() {
            int result = this.position1.hashCode();
            result = result * 31 + this.position2.hashCode();
            result = result * 31 + this.position3.hashCode();
            result = result * 31 + this.texCoord1.hashCode();
            result = result * 31 + this.texCoord2.hashCode();
            result = result * 31 + this.texCoord3.hashCode();
            result = result * 31 + this.normal1.hashCode();
            result = result * 31 + this.normal2.hashCode();
            result = result * 31 + this.normal3.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Triangle)) {
                return false;
            }
            Triangle triangle = (Triangle)other;
            if (!Intrinsics.areEqual((Object)this.position1, (Object)triangle.position1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.position2, (Object)triangle.position2)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.position3, (Object)triangle.position3)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.texCoord1, (Object)triangle.texCoord1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.texCoord2, (Object)triangle.texCoord2)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.texCoord3, (Object)triangle.texCoord3)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normal1, (Object)triangle.normal1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normal2, (Object)triangle.normal2)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.normal3, (Object)triangle.normal3);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgraphics/glimpse/meshes/MeshDataBuilder$Companion;", "", "()V", "TRIANGLE_VERTICES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

