/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.framebuffers;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.framebuffers.Renderbuffer;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.TextureInternalFormat;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgraphics/glimpse/framebuffers/RenderbufferFactoryImpl;", "Lgraphics/glimpse/framebuffers/Renderbuffer$Factory;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "createRenderbuffer", "Lgraphics/glimpse/framebuffers/Renderbuffer;", "width", "", "height", "internalFormat", "Lgraphics/glimpse/textures/TextureInternalFormat;", "RenderbufferImpl", "core"})
public final class RenderbufferFactoryImpl
implements Renderbuffer.Factory {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;

    public RenderbufferFactoryImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    @Override
    @NotNull
    public Renderbuffer createRenderbuffer(int width, int height, @NotNull TextureInternalFormat internalFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)internalFormat), (String)"internalFormat");
        this.logger.debug("Creating renderbuffer with internal format: " + internalFormat);
        int[] handles = new int[1];
        this.gl.glGenRenderbuffers(handles);
        int handle = ArraysKt.single((int[])handles);
        this.gl.glBindRenderbuffer(handle);
        this.gl.glRenderbufferStorage(internalFormat, width, height);
        return new RenderbufferImpl(handle);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lgraphics/glimpse/framebuffers/RenderbufferFactoryImpl$RenderbufferImpl;", "Lgraphics/glimpse/framebuffers/Renderbuffer;", "handle", "", "(I)V", "getHandle", "()I", "component1", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    public static final class RenderbufferImpl
    implements Renderbuffer {
        private final int handle;

        public RenderbufferImpl(int handle) {
            this.handle = handle;
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            int[] nArray = new int[]{this.getHandle()};
            int[] handles = nArray;
            gl.glDeleteRenderbuffers(handles);
        }

        public final int component1() {
            return this.getHandle();
        }

        @NotNull
        public final RenderbufferImpl copy(int handle) {
            return new RenderbufferImpl(handle);
        }

        public static /* synthetic */ RenderbufferImpl copy$default(RenderbufferImpl renderbufferImpl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = renderbufferImpl.getHandle();
            }
            return renderbufferImpl.copy(n);
        }

        @NotNull
        public String toString() {
            return "RenderbufferImpl(handle=" + this.getHandle() + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.getHandle());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderbufferImpl)) {
                return false;
            }
            RenderbufferImpl renderbufferImpl = (RenderbufferImpl)other;
            return this.getHandle() == renderbufferImpl.getHandle();
        }
    }
}

