/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.framebuffers;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.framebuffers.Framebuffer;
import graphics.glimpse.framebuffers.FramebufferAttachmentType;
import graphics.glimpse.framebuffers.FramebufferBuilderImpl;
import graphics.glimpse.framebuffers.FramebufferStatus;
import graphics.glimpse.framebuffers.Renderbuffer;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.textures.TextureType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgraphics/glimpse/framebuffers/FramebufferBuilderImpl;", "Lgraphics/glimpse/framebuffers/Framebuffer$Builder;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "renderbuffers", "", "Lgraphics/glimpse/framebuffers/FramebufferAttachmentType;", "Lgraphics/glimpse/framebuffers/Renderbuffer;", "textures", "Lgraphics/glimpse/textures/Texture;", "attachRenderbuffer", "type", "renderbuffer", "attachRenderbuffers", "", "attachTexture", "texture", "attachTextures", "build", "Lgraphics/glimpse/framebuffers/Framebuffer;", "checkFramebufferStatus", "framebufferHandles", "", "FramebufferImpl", "core"})
public final class FramebufferBuilderImpl
implements Framebuffer.Builder {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;
    @NotNull
    private final Map<FramebufferAttachmentType, Renderbuffer> renderbuffers;
    @NotNull
    private final Map<FramebufferAttachmentType, Texture> textures;

    public FramebufferBuilderImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
        this.renderbuffers = new LinkedHashMap();
        this.textures = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Framebuffer.Builder attachRenderbuffer(@NotNull FramebufferAttachmentType type, @NotNull Renderbuffer renderbuffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)renderbuffer, (String)"renderbuffer");
        this.textures.remove((Object)type);
        this.renderbuffers.put(type, renderbuffer);
        return this;
    }

    @Override
    @NotNull
    public Framebuffer.Builder attachTexture(@NotNull FramebufferAttachmentType type, @NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.renderbuffers.remove((Object)type);
        this.textures.put(type, texture);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Framebuffer build() {
        String attachments2 = SequencesKt.joinToString$default((Sequence)MapsKt.asSequence((Map)MapsKt.plus(this.renderbuffers, this.textures)), (CharSequence)"\n", null, null, (int)0, null, (Function1)build.attachments.1.INSTANCE, (int)30, null);
        this.logger.debug("Building framebuffer with attachments:\n" + attachments2);
        int[] handles = new int[1];
        this.gl.glGenFramebuffers(handles);
        int handle = ArraysKt.single((int[])handles);
        this.gl.glBindFramebuffer(handle);
        this.attachRenderbuffers();
        this.attachTextures();
        try {
            this.checkFramebufferStatus(handles);
        }
        finally {
            this.gl.glBindFramebuffer(0);
        }
        return new FramebufferImpl(handle, MapsKt.toMap(this.renderbuffers), MapsKt.toMap(this.textures));
    }

    private final void attachRenderbuffers() {
        for (Map.Entry<FramebufferAttachmentType, Renderbuffer> entry : this.renderbuffers.entrySet()) {
            FramebufferAttachmentType type = entry.getKey();
            Renderbuffer renderbuffer = entry.getValue();
            this.gl.glFramebufferRenderbuffer(type, renderbuffer.getHandle());
        }
    }

    private final void attachTextures() {
        for (Map.Entry<FramebufferAttachmentType, Texture> entry : this.textures.entrySet()) {
            FramebufferAttachmentType type = entry.getKey();
            Texture texture = entry.getValue();
            this.gl.glFramebufferTexture2D(type, TextureType.TEXTURE_2D, texture.getHandle());
        }
    }

    private final void checkFramebufferStatus(int[] framebufferHandles) {
        FramebufferStatus framebufferStatus = this.gl.glCheckFramebufferStatus();
        if (framebufferStatus != FramebufferStatus.COMPLETE) {
            this.gl.glDeleteFramebuffers(framebufferHandles);
            String errorMessage = "Framebuffer is not complete: " + framebufferStatus;
            this.logger.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J?\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0001J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lgraphics/glimpse/framebuffers/FramebufferBuilderImpl$FramebufferImpl;", "Lgraphics/glimpse/framebuffers/Framebuffer;", "handle", "", "renderbuffers", "", "Lgraphics/glimpse/framebuffers/FramebufferAttachmentType;", "Lgraphics/glimpse/framebuffers/Renderbuffer;", "textures", "Lgraphics/glimpse/textures/Texture;", "(ILjava/util/Map;Ljava/util/Map;)V", "getHandle", "()I", "getRenderbuffers", "()Ljava/util/Map;", "getTextures", "component1", "component2", "component3", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    public static final class FramebufferImpl
    implements Framebuffer {
        private final int handle;
        @NotNull
        private final Map<FramebufferAttachmentType, Renderbuffer> renderbuffers;
        @NotNull
        private final Map<FramebufferAttachmentType, Texture> textures;

        public FramebufferImpl(int handle, @NotNull Map<FramebufferAttachmentType, ? extends Renderbuffer> renderbuffers, @NotNull Map<FramebufferAttachmentType, ? extends Texture> textures) {
            Intrinsics.checkNotNullParameter(renderbuffers, (String)"renderbuffers");
            Intrinsics.checkNotNullParameter(textures, (String)"textures");
            this.handle = handle;
            this.renderbuffers = renderbuffers;
            this.textures = textures;
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        @NotNull
        public Map<FramebufferAttachmentType, Renderbuffer> getRenderbuffers() {
            return this.renderbuffers;
        }

        @Override
        @NotNull
        public Map<FramebufferAttachmentType, Texture> getTextures() {
            return this.textures;
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            Object object = new int[]{this.getHandle()};
            int[] handles = object;
            gl.glDeleteFramebuffers(handles);
            object = this.getRenderbuffers().values().iterator();
            while (object.hasNext()) {
                Renderbuffer renderbuffer = (Renderbuffer)object.next();
                renderbuffer.dispose(gl);
            }
            for (Texture texture : this.getTextures().values()) {
                texture.dispose(gl);
            }
        }

        public final int component1() {
            return this.getHandle();
        }

        @NotNull
        public final Map<FramebufferAttachmentType, Renderbuffer> component2() {
            return this.getRenderbuffers();
        }

        @NotNull
        public final Map<FramebufferAttachmentType, Texture> component3() {
            return this.getTextures();
        }

        @NotNull
        public final FramebufferImpl copy(int handle, @NotNull Map<FramebufferAttachmentType, ? extends Renderbuffer> renderbuffers, @NotNull Map<FramebufferAttachmentType, ? extends Texture> textures) {
            Intrinsics.checkNotNullParameter(renderbuffers, (String)"renderbuffers");
            Intrinsics.checkNotNullParameter(textures, (String)"textures");
            return new FramebufferImpl(handle, renderbuffers, textures);
        }

        public static /* synthetic */ FramebufferImpl copy$default(FramebufferImpl framebufferImpl, int n, Map map, Map map2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = framebufferImpl.getHandle();
            }
            if ((n2 & 2) != 0) {
                map = framebufferImpl.getRenderbuffers();
            }
            if ((n2 & 4) != 0) {
                map2 = framebufferImpl.getTextures();
            }
            return framebufferImpl.copy(n, map, map2);
        }

        @NotNull
        public String toString() {
            return "FramebufferImpl(handle=" + this.getHandle() + ", renderbuffers=" + this.getRenderbuffers() + ", textures=" + this.getTextures() + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.getHandle());
            result = result * 31 + ((Object)this.getRenderbuffers()).hashCode();
            result = result * 31 + ((Object)this.getTextures()).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FramebufferImpl)) {
                return false;
            }
            FramebufferImpl framebufferImpl = (FramebufferImpl)other;
            if (this.getHandle() != framebufferImpl.getHandle()) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getRenderbuffers(), framebufferImpl.getRenderbuffers())) {
                return false;
            }
            return Intrinsics.areEqual(this.getTextures(), framebufferImpl.getTextures());
        }
    }
}

