/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.cameras;

import graphics.glimpse.cameras.Camera;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.ViewMat4Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lgraphics/glimpse/cameras/TargetCamera;", "Lgraphics/glimpse/cameras/Camera;", "eye", "Lgraphics/glimpse/types/Vec3;", "target", "upVector", "(Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Vec3;)V", "getEye", "()Lgraphics/glimpse/types/Vec3;", "getTarget", "getUpVector", "viewMatrix", "Lgraphics/glimpse/types/Mat4;", "getViewMatrix", "()Lgraphics/glimpse/types/Mat4;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
public final class TargetCamera
implements Camera {
    @NotNull
    private final Vec3 eye;
    @NotNull
    private final Vec3 target;
    @NotNull
    private final Vec3 upVector;
    @NotNull
    private final Mat4 viewMatrix;

    public TargetCamera(@NotNull Vec3 eye, @NotNull Vec3 target, @NotNull Vec3 upVector) {
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)upVector, (String)"upVector");
        this.eye = eye;
        this.target = target;
        this.upVector = upVector;
        this.viewMatrix = ViewMat4Kt.lookAt(this.getEye(), this.target, this.upVector);
    }

    public /* synthetic */ TargetCamera(Vec3 vec3, Vec3 vec32, Vec3 vec33, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vec33 = Vec3.Companion.getUnitZ();
        }
        this(vec3, vec32, vec33);
    }

    @Override
    @NotNull
    public Vec3 getEye() {
        return this.eye;
    }

    @NotNull
    public final Vec3 getTarget() {
        return this.target;
    }

    @NotNull
    public final Vec3 getUpVector() {
        return this.upVector;
    }

    @Override
    @NotNull
    public Mat4 getViewMatrix() {
        return this.viewMatrix;
    }

    @NotNull
    public final Vec3 component1() {
        return this.getEye();
    }

    @NotNull
    public final Vec3 component2() {
        return this.target;
    }

    @NotNull
    public final Vec3 component3() {
        return this.upVector;
    }

    @NotNull
    public final TargetCamera copy(@NotNull Vec3 eye, @NotNull Vec3 target, @NotNull Vec3 upVector) {
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)upVector, (String)"upVector");
        return new TargetCamera(eye, target, upVector);
    }

    public static /* synthetic */ TargetCamera copy$default(TargetCamera targetCamera, Vec3 vec3, Vec3 vec32, Vec3 vec33, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = targetCamera.getEye();
        }
        if ((n & 2) != 0) {
            vec32 = targetCamera.target;
        }
        if ((n & 4) != 0) {
            vec33 = targetCamera.upVector;
        }
        return targetCamera.copy(vec3, vec32, vec33);
    }

    @NotNull
    public String toString() {
        return "TargetCamera(eye=" + this.getEye() + ", target=" + this.target + ", upVector=" + this.upVector + ")";
    }

    public int hashCode() {
        int result = this.getEye().hashCode();
        result = result * 31 + this.target.hashCode();
        result = result * 31 + this.upVector.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TargetCamera)) {
            return false;
        }
        TargetCamera targetCamera = (TargetCamera)other;
        if (!Intrinsics.areEqual((Object)this.getEye(), (Object)targetCamera.getEye())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.target, (Object)targetCamera.target)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.upVector, (Object)targetCamera.upVector);
    }
}

