/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.cameras;

import graphics.glimpse.cameras.Camera;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.ViewMat4Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lgraphics/glimpse/cameras/RelativeTargetCamera;", "Lgraphics/glimpse/cameras/Camera;", "target", "Lgraphics/glimpse/types/Vec3;", "distance", "", "longitude", "Lgraphics/glimpse/types/Angle;", "latitude", "upVector", "(Lgraphics/glimpse/types/Vec3;FLgraphics/glimpse/types/Angle;Lgraphics/glimpse/types/Angle;Lgraphics/glimpse/types/Vec3;)V", "getDistance", "()F", "eye", "getEye", "()Lgraphics/glimpse/types/Vec3;", "getLatitude", "()Lgraphics/glimpse/types/Angle;", "getLongitude", "getTarget", "getUpVector", "viewMatrix", "Lgraphics/glimpse/types/Mat4;", "getViewMatrix", "()Lgraphics/glimpse/types/Mat4;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
public final class RelativeTargetCamera
implements Camera {
    @NotNull
    private final Vec3 target;
    private final float distance;
    @NotNull
    private final Angle longitude;
    @NotNull
    private final Angle latitude;
    @NotNull
    private final Vec3 upVector;
    @NotNull
    private final Vec3 eye;
    @NotNull
    private final Mat4 viewMatrix;

    public RelativeTargetCamera(@NotNull Vec3 target, float distance, @NotNull Angle longitude, @NotNull Angle latitude, @NotNull Vec3 upVector) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
        Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
        Intrinsics.checkNotNullParameter((Object)upVector, (String)"upVector");
        this.target = target;
        this.distance = distance;
        this.longitude = longitude;
        this.latitude = latitude;
        this.upVector = upVector;
        this.eye = this.target.plus(Vec3.Companion.fromSphericalCoordinates(this.distance, this.longitude, this.latitude));
        this.viewMatrix = ViewMat4Kt.lookAt(this.getEye(), this.target, this.upVector);
    }

    public /* synthetic */ RelativeTargetCamera(Vec3 vec3, float f, Angle angle, Angle angle2, Vec3 vec32, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            vec32 = Vec3.Companion.getUnitZ();
        }
        this(vec3, f, angle, angle2, vec32);
    }

    @NotNull
    public final Vec3 getTarget() {
        return this.target;
    }

    public final float getDistance() {
        return this.distance;
    }

    @NotNull
    public final Angle getLongitude() {
        return this.longitude;
    }

    @NotNull
    public final Angle getLatitude() {
        return this.latitude;
    }

    @NotNull
    public final Vec3 getUpVector() {
        return this.upVector;
    }

    @Override
    @NotNull
    public Vec3 getEye() {
        return this.eye;
    }

    @Override
    @NotNull
    public Mat4 getViewMatrix() {
        return this.viewMatrix;
    }

    @NotNull
    public final Vec3 component1() {
        return this.target;
    }

    public final float component2() {
        return this.distance;
    }

    @NotNull
    public final Angle component3() {
        return this.longitude;
    }

    @NotNull
    public final Angle component4() {
        return this.latitude;
    }

    @NotNull
    public final Vec3 component5() {
        return this.upVector;
    }

    @NotNull
    public final RelativeTargetCamera copy(@NotNull Vec3 target, float distance, @NotNull Angle longitude, @NotNull Angle latitude, @NotNull Vec3 upVector) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
        Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
        Intrinsics.checkNotNullParameter((Object)upVector, (String)"upVector");
        return new RelativeTargetCamera(target, distance, longitude, latitude, upVector);
    }

    public static /* synthetic */ RelativeTargetCamera copy$default(RelativeTargetCamera relativeTargetCamera, Vec3 vec3, float f, Angle angle, Angle angle2, Vec3 vec32, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = relativeTargetCamera.target;
        }
        if ((n & 2) != 0) {
            f = relativeTargetCamera.distance;
        }
        if ((n & 4) != 0) {
            angle = relativeTargetCamera.longitude;
        }
        if ((n & 8) != 0) {
            angle2 = relativeTargetCamera.latitude;
        }
        if ((n & 0x10) != 0) {
            vec32 = relativeTargetCamera.upVector;
        }
        return relativeTargetCamera.copy(vec3, f, angle, angle2, vec32);
    }

    @NotNull
    public String toString() {
        return "RelativeTargetCamera(target=" + this.target + ", distance=" + this.distance + ", longitude=" + this.longitude + ", latitude=" + this.latitude + ", upVector=" + this.upVector + ")";
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = result * 31 + Float.hashCode(this.distance);
        result = result * 31 + this.longitude.hashCode();
        result = result * 31 + this.latitude.hashCode();
        result = result * 31 + this.upVector.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelativeTargetCamera)) {
            return false;
        }
        RelativeTargetCamera relativeTargetCamera = (RelativeTargetCamera)other;
        if (!Intrinsics.areEqual((Object)this.target, (Object)relativeTargetCamera.target)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.distance), (Object)Float.valueOf(relativeTargetCamera.distance))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.longitude, (Object)relativeTargetCamera.longitude)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.latitude, (Object)relativeTargetCamera.latitude)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.upVector, (Object)relativeTargetCamera.upVector);
    }
}

