/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.cameras;

import graphics.glimpse.cameras.Camera;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec3;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lgraphics/glimpse/cameras/FreeCamera;", "Lgraphics/glimpse/cameras/Camera;", "eye", "Lgraphics/glimpse/types/Vec3;", "roll", "Lgraphics/glimpse/types/Angle;", "pitch", "yaw", "(Lgraphics/glimpse/types/Vec3;Lgraphics/glimpse/types/Angle;Lgraphics/glimpse/types/Angle;Lgraphics/glimpse/types/Angle;)V", "getEye", "()Lgraphics/glimpse/types/Vec3;", "getPitch", "()Lgraphics/glimpse/types/Angle;", "getRoll", "viewMatrix", "Lgraphics/glimpse/types/Mat4;", "getViewMatrix", "()Lgraphics/glimpse/types/Mat4;", "getYaw", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "core"})
public final class FreeCamera
implements Camera {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec3 eye;
    @NotNull
    private final Angle roll;
    @NotNull
    private final Angle pitch;
    @NotNull
    private final Angle yaw;
    @NotNull
    private final Mat4 viewMatrix;
    @NotNull
    private static final Mat4 initialMatrix;

    /*
     * WARNING - void declaration
     */
    public FreeCamera(@NotNull Vec3 eye, @NotNull Angle roll, @NotNull Angle pitch, @NotNull Angle yaw) {
        void $this$reduce$iv;
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)roll, (String)"roll");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        Intrinsics.checkNotNullParameter((Object)yaw, (String)"yaw");
        this.eye = eye;
        this.roll = roll;
        this.pitch = pitch;
        this.yaw = yaw;
        Object object = new Mat4[]{initialMatrix, TransformationMat4Kt.rotationX(this.roll.unaryMinus()), TransformationMat4Kt.rotationY(this.pitch), TransformationMat4Kt.rotationZ(this.yaw.unaryMinus()), TransformationMat4Kt.translation(this.getEye().unaryMinus())};
        object = CollectionsKt.listOf((Object[])object);
        FreeCamera freeCamera = this;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void transformation;
            Mat4 mat4 = (Mat4)iterator$iv.next();
            Mat4 mat = (Mat4)accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Mat4)mat.times((Mat)transformation);
        }
        freeCamera.viewMatrix = (Mat4)accumulator$iv;
    }

    @Override
    @NotNull
    public Vec3 getEye() {
        return this.eye;
    }

    @NotNull
    public final Angle getRoll() {
        return this.roll;
    }

    @NotNull
    public final Angle getPitch() {
        return this.pitch;
    }

    @NotNull
    public final Angle getYaw() {
        return this.yaw;
    }

    @Override
    @NotNull
    public Mat4 getViewMatrix() {
        return this.viewMatrix;
    }

    @NotNull
    public final Vec3 component1() {
        return this.getEye();
    }

    @NotNull
    public final Angle component2() {
        return this.roll;
    }

    @NotNull
    public final Angle component3() {
        return this.pitch;
    }

    @NotNull
    public final Angle component4() {
        return this.yaw;
    }

    @NotNull
    public final FreeCamera copy(@NotNull Vec3 eye, @NotNull Angle roll, @NotNull Angle pitch, @NotNull Angle yaw) {
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)roll, (String)"roll");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        Intrinsics.checkNotNullParameter((Object)yaw, (String)"yaw");
        return new FreeCamera(eye, roll, pitch, yaw);
    }

    public static /* synthetic */ FreeCamera copy$default(FreeCamera freeCamera, Vec3 vec3, Angle angle, Angle angle2, Angle angle3, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = freeCamera.getEye();
        }
        if ((n & 2) != 0) {
            angle = freeCamera.roll;
        }
        if ((n & 4) != 0) {
            angle2 = freeCamera.pitch;
        }
        if ((n & 8) != 0) {
            angle3 = freeCamera.yaw;
        }
        return freeCamera.copy(vec3, angle, angle2, angle3);
    }

    @NotNull
    public String toString() {
        return "FreeCamera(eye=" + this.getEye() + ", roll=" + this.roll + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ")";
    }

    public int hashCode() {
        int result = this.getEye().hashCode();
        result = result * 31 + this.roll.hashCode();
        result = result * 31 + this.pitch.hashCode();
        result = result * 31 + this.yaw.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FreeCamera)) {
            return false;
        }
        FreeCamera freeCamera = (FreeCamera)other;
        if (!Intrinsics.areEqual((Object)this.getEye(), (Object)freeCamera.getEye())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.roll, (Object)freeCamera.roll)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pitch, (Object)freeCamera.pitch)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.yaw, (Object)freeCamera.yaw);
    }

    static {
        Object[] objectArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        initialMatrix = new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgraphics/glimpse/cameras/FreeCamera$Companion;", "", "()V", "initialMatrix", "Lgraphics/glimpse/types/Mat4;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

