/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.buffers;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/buffers/FloatBufferData;", "", "nioBuffer", "Ljava/nio/FloatBuffer;", "(Ljava/nio/FloatBuffer;)V", "getNioBuffer$core", "()Ljava/nio/FloatBuffer;", "sizeInBytes", "", "getSizeInBytes", "()I", "contentEquals", "", "other", "contentHashCode", "toString", "", "Companion", "core"})
public final class FloatBufferData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FloatBuffer nioBuffer;
    private static final int ELEMENT_SIZE = 4;
    private static final int MAX_ELEMENTS_TO_STRING = 32;

    public FloatBufferData(@NotNull FloatBuffer nioBuffer) {
        Intrinsics.checkNotNullParameter((Object)nioBuffer, (String)"nioBuffer");
        this.nioBuffer = nioBuffer;
    }

    @NotNull
    public final FloatBuffer getNioBuffer$core() {
        return this.nioBuffer;
    }

    public final int getSizeInBytes() {
        return this.nioBuffer.capacity() * 4;
    }

    public final boolean contentEquals(@NotNull FloatBufferData other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.nioBuffer, (Object)other.nioBuffer);
    }

    public final int contentHashCode() {
        return this.nioBuffer.hashCode();
    }

    @NotNull
    public String toString() {
        this.nioBuffer.rewind();
        int capacity = this.nioBuffer.capacity();
        int n = 32;
        float[] floats = new float[Math.min(capacity, n)];
        this.nioBuffer.get(floats);
        this.nioBuffer.rewind();
        return ArraysKt.joinToString$default((float[])floats, null, (CharSequence)("FloatBufferData(sizeInBytes=" + this.getSizeInBytes() + ", ["), (CharSequence)(capacity > 32 ? ", ... ])" : "])"), (int)0, null, null, (int)57, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgraphics/glimpse/buffers/FloatBufferData$Companion;", "", "()V", "ELEMENT_SIZE", "", "MAX_ELEMENTS_TO_STRING", "fromFloatArray", "Lgraphics/glimpse/buffers/FloatBufferData;", "floatArray", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatBufferData fromFloatArray(@NotNull float[] floatArray) {
            Intrinsics.checkNotNullParameter((Object)floatArray, (String)"floatArray");
            Buffer buffer = ByteBuffer.allocateDirect(floatArray.length * 4);
            ByteBuffer $this$fromFloatArray_u24lambda_u2d0 = buffer;
            boolean bl = false;
            $this$fromFloatArray_u24lambda_u2d0.order(ByteOrder.nativeOrder());
            Buffer $this$fromFloatArray_u24lambda_u2d1 = buffer = ((ByteBuffer)buffer).asFloatBuffer().put(floatArray);
            boolean bl2 = false;
            ((FloatBuffer)$this$fromFloatArray_u24lambda_u2d1).rewind();
            Buffer p0 = buffer;
            boolean bl3 = false;
            return new FloatBufferData((FloatBuffer)p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

