/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.buffers;

import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.buffers.IntBufferData;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0002\u001a\u00020\u0007\"\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\n\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0007\u001a\u0010\u0010\u000b\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\f"}, d2={"floatBufferDataOf", "Lgraphics/glimpse/buffers/FloatBufferData;", "elements", "", "", "intBufferDataOf", "Lgraphics/glimpse/buffers/IntBufferData;", "", "", "toFloatBufferData", "", "toIntBufferData", "core"})
public final class BufferDataExtensionsKt {
    @NotNull
    public static final FloatBufferData toFloatBufferData(@NotNull float[] $this$toFloatBufferData) {
        Intrinsics.checkNotNullParameter((Object)$this$toFloatBufferData, (String)"<this>");
        return FloatBufferData.Companion.fromFloatArray($this$toFloatBufferData);
    }

    @NotNull
    public static final IntBufferData toIntBufferData(@NotNull int[] $this$toIntBufferData) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntBufferData, (String)"<this>");
        return IntBufferData.Companion.fromIntArray($this$toIntBufferData);
    }

    @NotNull
    public static final FloatBufferData toFloatBufferData(@NotNull Collection<Float> $this$toFloatBufferData) {
        Intrinsics.checkNotNullParameter($this$toFloatBufferData, (String)"<this>");
        return BufferDataExtensionsKt.toFloatBufferData(CollectionsKt.toFloatArray($this$toFloatBufferData));
    }

    @NotNull
    public static final IntBufferData toIntBufferData(@NotNull Collection<Integer> $this$toIntBufferData) {
        Intrinsics.checkNotNullParameter($this$toIntBufferData, (String)"<this>");
        return BufferDataExtensionsKt.toIntBufferData(CollectionsKt.toIntArray($this$toIntBufferData));
    }

    @NotNull
    public static final FloatBufferData floatBufferDataOf(float ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return BufferDataExtensionsKt.toFloatBufferData(Arrays.copyOf(elements, elements.length));
    }

    @NotNull
    public static final IntBufferData intBufferDataOf(int ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return BufferDataExtensionsKt.toIntBufferData(Arrays.copyOf(elements, elements.length));
    }
}

