/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.Angle;
import graphics.glimpse.types.AngleMathKt;
import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\t\u0010-\u001a\u00020\u0000H\u0086\u0002J\t\u0010.\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u00060"}, d2={"Lgraphics/glimpse/types/Vec3;", "Lgraphics/glimpse/types/Vec;", "x", "", "y", "z", "(FFF)V", "b", "getB", "()F", "g", "getG", "r", "getR", "getX", "getY", "getZ", "component1", "component2", "component3", "copy", "cross", "other", "div", "number", "dot", "equals", "", "", "hashCode", "", "minus", "plus", "times", "toFloatArray", "", "toList", "", "toString", "", "toVec2", "Lgraphics/glimpse/types/Vec2;", "toVec4", "Lgraphics/glimpse/types/Vec4;", "w", "unaryMinus", "unaryPlus", "Companion", "core"})
public final class Vec3
implements Vec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    private static final int SIZE = 3;
    @NotNull
    private static final Vec3 nullVector = new Vec3(0.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vec3 unitX = new Vec3(1.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vec3 unitY = new Vec3(0.0f, 1.0f, 0.0f);
    @NotNull
    private static final Vec3 unitZ = new Vec3(0.0f, 0.0f, 1.0f);

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float getR() {
        return this.x;
    }

    public final float getG() {
        return this.y;
    }

    public final float getB() {
        return this.z;
    }

    @NotNull
    public final Vec3 unaryPlus() {
        return this;
    }

    @NotNull
    public final Vec3 unaryMinus() {
        return new Vec3(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final Vec3 plus(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final Vec3 minus(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final Vec3 times(float number) {
        return new Vec3(this.x * number, this.y * number, this.z * number);
    }

    @NotNull
    public final Vec3 div(float number) {
        return new Vec3(this.x / number, this.y / number, this.z / number);
    }

    /*
     * WARNING - void declaration
     */
    public final float dot(@NotNull Vec3 other) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)this.toList(), (Iterable)other.toList());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$a$b;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float a = ((Number)$dstr$a$b.component1()).floatValue();
            float b = ((Number)$dstr$a$b.component2()).floatValue();
            collection.add(Float.valueOf(a * b));
        }
        return CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Vec3 cross(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    @NotNull
    public final Vec2 toVec2() {
        return new Vec2(this.x, this.y);
    }

    @NotNull
    public final Vec4 toVec4(float w) {
        return new Vec4(this.x, this.y, this.z, w);
    }

    public static /* synthetic */ Vec4 toVec4$default(Vec3 vec3, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        return vec3.toVec4(f);
    }

    @Override
    @NotNull
    public List<Float> toList() {
        Object[] objectArray = new Float[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public float[] toFloatArray() {
        float[] fArray = new float[]{this.x, this.y, this.z};
        return fArray;
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vec3 copy(float x, float y, float z) {
        return new Vec3(x, y, z);
    }

    public static /* synthetic */ Vec3 copy$default(Vec3 vec3, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vec3.x;
        }
        if ((n & 2) != 0) {
            f2 = vec3.y;
        }
        if ((n & 4) != 0) {
            f3 = vec3.z;
        }
        return vec3.copy(f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "Vec3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        result = result * 31 + Float.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vec3)) {
            return false;
        }
        Vec3 vec3 = (Vec3)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(vec3.x))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(vec3.y))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.z), (Object)Float.valueOf(vec3.z));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0018"}, d2={"Lgraphics/glimpse/types/Vec3$Companion;", "", "()V", "SIZE", "", "nullVector", "Lgraphics/glimpse/types/Vec3;", "getNullVector", "()Lgraphics/glimpse/types/Vec3;", "unitX", "getUnitX", "unitY", "getUnitY", "unitZ", "getUnitZ", "fromList", "list", "", "", "fromSphericalCoordinates", "distance", "longitude", "Lgraphics/glimpse/types/Angle;", "latitude", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vec3 getNullVector() {
            return nullVector;
        }

        @NotNull
        public final Vec3 getUnitX() {
            return unitX;
        }

        @NotNull
        public final Vec3 getUnitY() {
            return unitY;
        }

        @NotNull
        public final Vec3 getUnitZ() {
            return unitZ;
        }

        @NotNull
        public final Vec3 fromList(@NotNull List<Float> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (!(list.size() == 3)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            float x = ((Number)list.get(0)).floatValue();
            float y = ((Number)list.get(1)).floatValue();
            float z = ((Number)list.get(2)).floatValue();
            return new Vec3(x, y, z);
        }

        @NotNull
        public final Vec3 fromSphericalCoordinates(float distance, @NotNull Angle longitude, @NotNull Angle latitude) {
            Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
            Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
            return new Vec3(distance * AngleMathKt.cos(longitude) * AngleMathKt.cos(latitude), distance * AngleMathKt.sin(longitude) * AngleMathKt.cos(latitude), distance * AngleMathKt.sin(latitude));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

