/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.AngleRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001e\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006 "}, d2={"Lgraphics/glimpse/types/Angle;", "", "deg", "", "rad", "(FF)V", "getDeg", "()F", "getRad", "coerceIn", "minimumAngle", "maximumAngle", "compareTo", "", "other", "div", "number", "equals", "", "", "hashCode", "minus", "plus", "rangeTo", "Lgraphics/glimpse/types/AngleRange;", "rem", "times", "toString", "", "unaryMinus", "unaryPlus", "Companion", "core"})
public final class Angle
implements Comparable<Angle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float deg;
    private final float rad;
    private static final float STRAIGHT_ANGLE_DEG = 180.0f;
    @NotNull
    private static final Angle nullAngle = Companion.fromDeg(0.0f);
    @NotNull
    private static final Angle rightAngle = Companion.fromDeg(90.0f);
    @NotNull
    private static final Angle straightAngle = Companion.fromDeg(180.0f);
    @NotNull
    private static final Angle fullAngle = Companion.fromDeg(360.0f);

    private Angle(float deg, float rad) {
        this.deg = deg;
        this.rad = rad;
    }

    public final float getDeg() {
        return this.deg;
    }

    public final float getRad() {
        return this.rad;
    }

    @NotNull
    public final Angle unaryPlus() {
        return this;
    }

    @NotNull
    public final Angle unaryMinus() {
        return Companion.fromDeg(-this.deg);
    }

    @NotNull
    public final Angle plus(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.fromDeg(this.deg + other.deg);
    }

    @NotNull
    public final Angle minus(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.fromDeg(this.deg - other.deg);
    }

    @NotNull
    public final Angle times(float number) {
        return Companion.fromDeg(this.deg * number);
    }

    @NotNull
    public final Angle div(float number) {
        return Companion.fromDeg(this.deg / number);
    }

    public final float div(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.deg / other.deg;
    }

    @NotNull
    public final Angle rem(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.fromDeg(this.deg % other.deg);
    }

    @NotNull
    public final Angle coerceIn(@NotNull Angle minimumAngle, @NotNull Angle maximumAngle) {
        Intrinsics.checkNotNullParameter((Object)minimumAngle, (String)"minimumAngle");
        Intrinsics.checkNotNullParameter((Object)maximumAngle, (String)"maximumAngle");
        return Companion.fromDeg(RangesKt.coerceIn((float)this.deg, (float)minimumAngle.deg, (float)maximumAngle.deg));
    }

    @NotNull
    public final AngleRange rangeTo(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new AngleRange(this, other);
    }

    @Override
    public int compareTo(@NotNull Angle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Float.compare(this.deg, other.deg);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        Angle cfr_ignored_0 = (Angle)other;
        if (!(this.deg == ((Angle)other).deg)) {
            return false;
        }
        return this.rad == ((Angle)other).rad;
    }

    public int hashCode() {
        int result = Float.hashCode(this.deg);
        result = 31 * result + Float.hashCode(this.rad);
        return result;
    }

    @NotNull
    public String toString() {
        return "Angle(deg=" + this.deg + ", rad=" + this.rad + ")";
    }

    public /* synthetic */ Angle(float deg, float rad, DefaultConstructorMarker $constructor_marker) {
        this(deg, rad);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0018"}, d2={"Lgraphics/glimpse/types/Angle$Companion;", "", "()V", "STRAIGHT_ANGLE_DEG", "", "fullAngle", "Lgraphics/glimpse/types/Angle;", "getFullAngle", "()Lgraphics/glimpse/types/Angle;", "nullAngle", "getNullAngle", "rightAngle", "getRightAngle", "straightAngle", "getStraightAngle", "atan", "value", "atan2", "y", "x", "fromDeg", "deg", "fromRad", "rad", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Angle getNullAngle() {
            return nullAngle;
        }

        @NotNull
        public final Angle getRightAngle() {
            return rightAngle;
        }

        @NotNull
        public final Angle getStraightAngle() {
            return straightAngle;
        }

        @NotNull
        public final Angle getFullAngle() {
            return fullAngle;
        }

        @NotNull
        public final Angle fromDeg(float deg) {
            return new Angle(deg, deg * (float)Math.PI / 180.0f, null);
        }

        @NotNull
        public final Angle fromRad(float rad) {
            return new Angle(rad * 180.0f / (float)Math.PI, rad, null);
        }

        @NotNull
        public final Angle atan(float value) {
            return this.fromRad((float)Math.atan(value));
        }

        @NotNull
        public final Angle atan2(float y, float x) {
            return this.fromRad((float)Math.atan2(y, x));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

