/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.textures;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.EmptyTexturePresets;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.textures.TextureMagFilter;
import graphics.glimpse.textures.TextureMinFilter;
import graphics.glimpse.textures.TextureType;
import graphics.glimpse.textures.TextureWrap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgraphics/glimpse/textures/EmptyTextureFactory;", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "create", "Lgraphics/glimpse/textures/Texture;", "width", "", "height", "presets", "Lgraphics/glimpse/textures/EmptyTexturePresets;", "TextureImpl", "core"})
public final class EmptyTextureFactory {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;

    public EmptyTextureFactory(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    @NotNull
    public final Texture create(int width, int height, @NotNull EmptyTexturePresets presets) {
        Intrinsics.checkNotNullParameter((Object)presets, (String)"presets");
        this.logger.debug("Generating empty texture with presets: " + presets);
        int[] handles = new int[1];
        this.gl.glGenTextures(handles);
        int textureHandle = ArraysKt.single((int[])handles);
        this.gl.glBindTexture(TextureType.TEXTURE_2D, textureHandle);
        this.gl.glTexImage2D(presets.getInternalFormat(), width, height, presets.getPixelFormat(), presets.getPixelType(), null);
        this.gl.glTexParameterFilter(TextureType.TEXTURE_2D, TextureMinFilter.LINEAR, TextureMagFilter.LINEAR);
        this.gl.glTexParameterWrap(TextureType.TEXTURE_2D, TextureWrap.CLAMP_TO_EDGE, TextureWrap.CLAMP_TO_EDGE);
        return new TextureImpl(textureHandle);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lgraphics/glimpse/textures/EmptyTextureFactory$TextureImpl;", "Lgraphics/glimpse/textures/Texture;", "handle", "", "(I)V", "getHandle", "()I", "component1", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "useAtIndex", "textureIndex", "core"})
    public static final class TextureImpl
    implements Texture {
        private final int handle;

        public TextureImpl(int handle) {
            this.handle = handle;
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void useAtIndex(@NotNull GlimpseAdapter gl, int textureIndex) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glActiveTexture(textureIndex);
            gl.glBindTexture(TextureType.TEXTURE_2D, this.getHandle());
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            int[] nArray = new int[]{this.getHandle()};
            int[] handles = nArray;
            gl.glDeleteTextures(handles);
        }

        public final int component1() {
            return this.getHandle();
        }

        @NotNull
        public final TextureImpl copy(int handle) {
            return new TextureImpl(handle);
        }

        public static /* synthetic */ TextureImpl copy$default(TextureImpl textureImpl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = textureImpl.getHandle();
            }
            return textureImpl.copy(n);
        }

        @NotNull
        public String toString() {
            return "TextureImpl(handle=" + this.getHandle() + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.getHandle());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureImpl)) {
                return false;
            }
            TextureImpl textureImpl = (TextureImpl)other;
            return this.getHandle() == textureImpl.getHandle();
        }
    }
}

