/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.shaders;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.shaders.Shader;
import graphics.glimpse.shaders.ShaderType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/shaders/ShaderFactoryImpl;", "Lgraphics/glimpse/shaders/Shader$Factory;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "compileShader", "", "handle", "", "type", "Lgraphics/glimpse/shaders/ShaderType;", "createShader", "Lgraphics/glimpse/shaders/Shader;", "source", "", "ShaderImpl", "core"})
public final class ShaderFactoryImpl
implements Shader.Factory {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;

    public ShaderFactoryImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    @Override
    @NotNull
    public Shader createShader(@NotNull ShaderType type, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.logger.debug("Compiling shader from sources:\n" + source);
        int handle = this.gl.glCreateShader(type);
        this.gl.glShaderSource(handle, source);
        this.compileShader(handle, type);
        return new ShaderImpl(handle);
    }

    private final void compileShader(int handle, ShaderType type) {
        this.gl.glCompileShader(handle);
        if (!this.gl.glGetShaderCompileStatus(handle)) {
            String shaderInfoLog = this.gl.glGetShaderInfoLog(handle);
            this.logger.error(type + " compilation failed:\n" + shaderInfoLog + "\nCleaning up");
            this.gl.glDeleteShader(handle);
            throw new IllegalStateException(type + " compilation failed:\n" + shaderInfoLog);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgraphics/glimpse/shaders/ShaderFactoryImpl$ShaderImpl;", "Lgraphics/glimpse/shaders/Shader;", "handle", "", "(I)V", "getHandle", "()I", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "component1", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    private static final class ShaderImpl
    implements Shader {
        private final int handle;
        @NotNull
        private final GlimpseLogger logger;

        public ShaderImpl(int handle) {
            this.handle = handle;
            this.logger = GlimpseLogger.Companion.create(this);
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glDeleteShader(this.getHandle());
            if (!gl.glGetShaderDeleteStatus(this.getHandle())) {
                String shaderInfoLog = gl.glGetShaderInfoLog(this.getHandle());
                this.logger.error("Shader deletion failed:\n" + shaderInfoLog);
                throw new IllegalStateException("Shader deletion failed:\n" + shaderInfoLog);
            }
        }

        public final int component1() {
            return this.getHandle();
        }

        @NotNull
        public final ShaderImpl copy(int handle) {
            return new ShaderImpl(handle);
        }

        public static /* synthetic */ ShaderImpl copy$default(ShaderImpl shaderImpl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = shaderImpl.getHandle();
            }
            return shaderImpl.copy(n);
        }

        @NotNull
        public String toString() {
            return "ShaderImpl(handle=" + this.getHandle() + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.getHandle());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShaderImpl)) {
                return false;
            }
            ShaderImpl shaderImpl = (ShaderImpl)other;
            return this.getHandle() == shaderImpl.getHandle();
        }
    }
}

