/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.lenses;

import graphics.glimpse.lenses.Lens;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.ProjectionMat4Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lgraphics/glimpse/lenses/PerspectiveLens;", "Lgraphics/glimpse/lenses/Lens;", "fovY", "Lgraphics/glimpse/types/Angle;", "aspect", "", "near", "far", "(Lgraphics/glimpse/types/Angle;FFF)V", "getAspect", "()F", "getFar", "getFovY", "()Lgraphics/glimpse/types/Angle;", "getNear", "projectionMatrix", "Lgraphics/glimpse/types/Mat4;", "getProjectionMatrix", "()Lgraphics/glimpse/types/Mat4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
public final class PerspectiveLens
implements Lens {
    @NotNull
    private final Angle fovY;
    private final float aspect;
    private final float near;
    private final float far;
    @NotNull
    private final Mat4 projectionMatrix;

    public PerspectiveLens(@NotNull Angle fovY, float aspect, float near, float far) {
        Intrinsics.checkNotNullParameter((Object)fovY, (String)"fovY");
        this.fovY = fovY;
        this.aspect = aspect;
        this.near = near;
        this.far = far;
        this.projectionMatrix = ProjectionMat4Kt.perspective(this.fovY, this.aspect, this.near, this.far);
    }

    @NotNull
    public final Angle getFovY() {
        return this.fovY;
    }

    public final float getAspect() {
        return this.aspect;
    }

    public final float getNear() {
        return this.near;
    }

    public final float getFar() {
        return this.far;
    }

    @Override
    @NotNull
    public Mat4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @NotNull
    public final Angle component1() {
        return this.fovY;
    }

    public final float component2() {
        return this.aspect;
    }

    public final float component3() {
        return this.near;
    }

    public final float component4() {
        return this.far;
    }

    @NotNull
    public final PerspectiveLens copy(@NotNull Angle fovY, float aspect, float near, float far) {
        Intrinsics.checkNotNullParameter((Object)fovY, (String)"fovY");
        return new PerspectiveLens(fovY, aspect, near, far);
    }

    public static /* synthetic */ PerspectiveLens copy$default(PerspectiveLens perspectiveLens, Angle angle, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            angle = perspectiveLens.fovY;
        }
        if ((n & 2) != 0) {
            f = perspectiveLens.aspect;
        }
        if ((n & 4) != 0) {
            f2 = perspectiveLens.near;
        }
        if ((n & 8) != 0) {
            f3 = perspectiveLens.far;
        }
        return perspectiveLens.copy(angle, f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "PerspectiveLens(fovY=" + this.fovY + ", aspect=" + this.aspect + ", near=" + this.near + ", far=" + this.far + ")";
    }

    public int hashCode() {
        int result = this.fovY.hashCode();
        result = result * 31 + Float.hashCode(this.aspect);
        result = result * 31 + Float.hashCode(this.near);
        result = result * 31 + Float.hashCode(this.far);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PerspectiveLens)) {
            return false;
        }
        PerspectiveLens perspectiveLens = (PerspectiveLens)other;
        if (!Intrinsics.areEqual((Object)this.fovY, (Object)perspectiveLens.fovY)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.aspect), (Object)Float.valueOf(perspectiveLens.aspect))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.near), (Object)Float.valueOf(perspectiveLens.near))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.far), (Object)Float.valueOf(perspectiveLens.far));
    }
}

