/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.buffers;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.buffers.Buffer;
import graphics.glimpse.buffers.BufferType;
import graphics.glimpse.buffers.BufferUsage;
import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.buffers.IntBufferData;
import graphics.glimpse.logging.GlimpseLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000b\"\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/buffers/BufferFactoryImpl;", "Lgraphics/glimpse/buffers/Buffer$Factory;", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "(Lgraphics/glimpse/GlimpseAdapter;)V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "createArrayBuffers", "", "Lgraphics/glimpse/buffers/Buffer;", "buffersData", "", "Lgraphics/glimpse/buffers/FloatBufferData;", "([Lgraphics/glimpse/buffers/FloatBufferData;)Ljava/util/List;", "createElementArrayBuffers", "Lgraphics/glimpse/buffers/IntBufferData;", "([Lgraphics/glimpse/buffers/IntBufferData;)Ljava/util/List;", "BufferImpl", "core"})
public final class BufferFactoryImpl
implements Buffer.Factory {
    @NotNull
    private final GlimpseAdapter gl;
    @NotNull
    private final GlimpseLogger logger;

    public BufferFactoryImpl(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.gl = gl;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Buffer> createArrayBuffers(FloatBufferData ... buffersData) {
        void $this$mapIndexedTo$iv$iv;
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)buffersData, (String)"buffersData");
        int buffersCount = buffersData.length;
        FloatBufferData[] floatBufferDataArray = buffersData;
        int n = buffersCount;
        Object object = this.logger;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        FloatBufferData[] destination$iv$iv = (FloatBufferData[])new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var12_20 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSizeInBytes());
        }
        collection = (List)destination$iv$iv;
        object.debug("Creating " + n + " array buffers with sizes: " + (List)collection + " bytes");
        int[] handles = new int[buffersCount];
        this.gl.glGenBuffers(handles);
        FloatBufferData[] $this$mapIndexed$iv = buffersData;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void bufferData;
            void index;
            int n2 = index$iv$iv;
            index$iv$iv = n2 + 1;
            void var15_26 = item$iv$iv;
            int n3 = n2;
            object = destination$iv$iv2;
            boolean bl = false;
            this.gl.glBindBuffer(BufferType.ARRAY_BUFFER, handles[index]);
            this.gl.glBufferData(BufferType.ARRAY_BUFFER, (FloatBufferData)bufferData, BufferUsage.STATIC_DRAW);
            object.add(new BufferImpl(BufferType.ARRAY_BUFFER, handles[index]));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Buffer> createElementArrayBuffers(IntBufferData ... buffersData) {
        void $this$mapIndexedTo$iv$iv;
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)buffersData, (String)"buffersData");
        int buffersCount = buffersData.length;
        IntBufferData[] intBufferDataArray = buffersData;
        int n = buffersCount;
        Object object = this.logger;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        IntBufferData[] destination$iv$iv = (IntBufferData[])new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var12_20 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSizeInBytes());
        }
        collection = (List)destination$iv$iv;
        object.debug("Creating " + n + " element array buffers with sizes: " + (List)collection + " bytes");
        int[] handles = new int[buffersCount];
        this.gl.glGenBuffers(handles);
        IntBufferData[] $this$mapIndexed$iv = buffersData;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void bufferData;
            void index;
            int n2 = index$iv$iv;
            index$iv$iv = n2 + 1;
            void var15_26 = item$iv$iv;
            int n3 = n2;
            object = destination$iv$iv2;
            boolean bl = false;
            this.gl.glBindBuffer(BufferType.ELEMENT_ARRAY_BUFFER, handles[index]);
            this.gl.glBufferData(BufferType.ELEMENT_ARRAY_BUFFER, (IntBufferData)bufferData, BufferUsage.STATIC_DRAW);
            object.add(new BufferImpl(BufferType.ELEMENT_ARRAY_BUFFER, handles[index]));
        }
        return (List)destination$iv$iv2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lgraphics/glimpse/buffers/BufferFactoryImpl$BufferImpl;", "Lgraphics/glimpse/buffers/Buffer;", "type", "Lgraphics/glimpse/buffers/BufferType;", "handle", "", "(Lgraphics/glimpse/buffers/BufferType;I)V", "getHandle", "()I", "getType", "()Lgraphics/glimpse/buffers/BufferType;", "component1", "component2", "copy", "dispose", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "equals", "", "other", "", "hashCode", "toString", "", "use", "core"})
    private static final class BufferImpl
    implements Buffer {
        @NotNull
        private final BufferType type;
        private final int handle;

        public BufferImpl(@NotNull BufferType type, int handle) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.handle = handle;
        }

        @Override
        @NotNull
        public BufferType getType() {
            return this.type;
        }

        @Override
        public int getHandle() {
            return this.handle;
        }

        @Override
        public void use(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            gl.glBindBuffer(this.getType(), this.getHandle());
        }

        @Override
        public void dispose(@NotNull GlimpseAdapter gl) {
            Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
            int[] nArray = new int[]{this.getHandle()};
            gl.glDeleteBuffers(nArray);
        }

        @NotNull
        public final BufferType component1() {
            return this.getType();
        }

        public final int component2() {
            return this.getHandle();
        }

        @NotNull
        public final BufferImpl copy(@NotNull BufferType type, int handle) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new BufferImpl(type, handle);
        }

        public static /* synthetic */ BufferImpl copy$default(BufferImpl bufferImpl, BufferType bufferType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bufferType = bufferImpl.getType();
            }
            if ((n2 & 2) != 0) {
                n = bufferImpl.getHandle();
            }
            return bufferImpl.copy(bufferType, n);
        }

        @NotNull
        public String toString() {
            return "BufferImpl(type=" + this.getType() + ", handle=" + this.getHandle() + ")";
        }

        public int hashCode() {
            int result = this.getType().hashCode();
            result = result * 31 + Integer.hashCode(this.getHandle());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BufferImpl)) {
                return false;
            }
            BufferImpl bufferImpl = (BufferImpl)other;
            if (this.getType() != bufferImpl.getType()) {
                return false;
            }
            return this.getHandle() == bufferImpl.getHandle();
        }
    }
}

