/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse;

import com.jogamp.opengl.GL2ES2;
import graphics.glimpse.BlendingFactorFunction;
import graphics.glimpse.ClearableBufferType;
import graphics.glimpse.DepthTestFunction;
import graphics.glimpse.DrawingMode;
import graphics.glimpse.FaceCullingMode;
import graphics.glimpse.PixelFormat;
import graphics.glimpse.buffers.BufferType;
import graphics.glimpse.buffers.BufferUsage;
import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.buffers.IntBufferData;
import graphics.glimpse.framebuffers.FramebufferAttachmentType;
import graphics.glimpse.framebuffers.FramebufferStatus;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.shaders.ShaderType;
import graphics.glimpse.textures.TextureInternalFormat;
import graphics.glimpse.textures.TextureMagFilter;
import graphics.glimpse.textures.TextureMinFilter;
import graphics.glimpse.textures.TexturePixelFormat;
import graphics.glimpse.textures.TexturePixelType;
import graphics.glimpse.textures.TextureType;
import graphics.glimpse.textures.TextureWrap;
import graphics.glimpse.types.Mat2;
import graphics.glimpse.types.Mat3;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u001e\u0010'\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u001e\u0010'\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020,2\u0006\u0010*\u001a\u00020+J\u0006\u0010-\u001a\u00020\u000eJ\u001f\u0010.\u001a\u00020\u00102\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020\u00102\u0006\u0010!\u001a\u000204J\u000e\u00103\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\u000e\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u00109\u001a\u00020\fJ\u000e\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020BJ\u000e\u0010E\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020BJ\u000e\u0010H\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020BJ\u000e\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020\u0010J\u0006\u0010O\u001a\u00020\u0010J\u0006\u0010P\u001a\u00020\u0010J\u000e\u0010Q\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\fJ \u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\f2\b\b\u0002\u0010W\u001a\u00020\fJ \u0010X\u001a\u00020\u00102\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\f2\b\b\u0002\u0010W\u001a\u00020\fJ\u0006\u0010Y\u001a\u00020\u0010J\u0006\u0010Z\u001a\u00020\u0010J\u0006\u0010[\u001a\u00020\u0010J\u000e\u0010\\\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\fJ\u0016\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020_2\u0006\u0010\u001c\u001a\u00020\fJ\u001e\u0010`\u001a\u00020\u00102\u0006\u0010^\u001a\u00020_2\u0006\u0010a\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010b\u001a\u00020\u00102\u0006\u0010A\u001a\u00020BJ\u000e\u0010c\u001a\u00020\u00102\u0006\u0010D\u001a\u00020BJ\u000e\u0010d\u001a\u00020\u00102\u0006\u0010G\u001a\u00020BJ\u000e\u0010e\u001a\u00020\u00102\u0006\u0010J\u001a\u00020BJ\u000e\u0010f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001eJ\u0016\u0010g\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010h\u001a\u00020iJ\u0010\u0010j\u001a\u00020\f2\u0006\u0010k\u001a\u00020\fH\u0002J\u000e\u0010l\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010m\u001a\u00020i2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010n\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010o\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010p\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010q\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010r\u001a\u00020i2\u0006\u0010\u0014\u001a\u00020\fJ\u0016\u0010s\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010h\u001a\u00020iJ\u000e\u0010t\u001a\u00020\u00102\u0006\u0010u\u001a\u000207J\u000e\u0010v\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010w\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001eJ4\u0010x\u001a\u00020y2\b\b\u0002\u0010z\u001a\u00020\f2\b\b\u0002\u0010{\u001a\u00020\f2\u0006\u0010|\u001a\u00020\f2\u0006\u0010}\u001a\u00020\f2\b\b\u0002\u0010~\u001a\u00020\u007fJ!\u0010\u0080\u0001\u001a\u00020\u00102\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010|\u001a\u00020\f2\u0006\u0010}\u001a\u00020\fJ\u0018\u0010\u0083\u0001\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0007\u0010\u0084\u0001\u001a\u00020iJ@\u0010\u0085\u0001\u001a\u00020\u00102\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010|\u001a\u00020\f2\u0006\u0010}\u001a\u00020\f2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010yJ#\u0010\u008b\u0001\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001e2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001J#\u0010\u0090\u0001\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001e2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010\u0093\u0001\u001a\u00030\u0092\u0001J\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001J\u0018\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0007\u0010\u000b\u001a\u00030\u0097\u0001J\u0017\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u000204J\u0017\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\"J7\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0015\u0010\u0098\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u0099\u000100\"\u00030\u0099\u00012\t\b\u0002\u0010\u009a\u0001\u001a\u00020\n\u00a2\u0006\u0003\u0010\u009b\u0001J7\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0015\u0010\u0098\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u009c\u000100\"\u00030\u009c\u00012\t\b\u0002\u0010\u009a\u0001\u001a\u00020\n\u00a2\u0006\u0003\u0010\u009d\u0001J7\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0015\u0010\u0098\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u009e\u000100\"\u00030\u009e\u00012\t\b\u0002\u0010\u009a\u0001\u001a\u00020\n\u00a2\u0006\u0003\u0010\u009f\u0001J,\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0015\u0010\u0098\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u0097\u000100\"\u00030\u0097\u0001\u00a2\u0006\u0003\u0010\u00a0\u0001J*\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0013\u0010\u0098\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020400\"\u000204\u00a2\u0006\u0003\u0010\u00a1\u0001J*\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0013\u0010\u0098\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"00\"\u00020\"\u00a2\u0006\u0003\u0010\u00a2\u0001J\u0017\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nJ\u0017\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u000207J\u001d\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\f\u0010\u0098\u0001\u001a\u00030\u00a3\u0001\"\u000207J\u0017\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u000b\u0010\u0098\u0001\u001a\u00020B\"\u00020\fJ\u000f\u0010\u00a4\u0001\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fJ\u000f\u0010\u00a5\u0001\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fJ8\u0010\u00a6\u0001\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\f2\u0007\u0010\u00a7\u0001\u001a\u00020\f2\t\b\u0002\u0010\u00a8\u0001\u001a\u00020\n2\t\b\u0002\u0010\u00a9\u0001\u001a\u00020\f2\b\b\u0002\u0010W\u001a\u00020\fJ+\u0010\u00aa\u0001\u001a\u00020\u00102\b\b\u0002\u0010z\u001a\u00020\f2\b\b\u0002\u0010{\u001a\u00020\f2\u0006\u0010|\u001a\u00020\f2\u0006\u0010}\u001a\u00020\fJ\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020%H\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u000201H\u0002J\u0015\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\f*\u00020MH\u0002\u00a2\u0006\u0003\u0010\u00ac\u0001J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020UH\u0002J\u0015\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\f*\u00020?H\u0002\u00a2\u0006\u0003\u0010\u00ad\u0001J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020\u007fH\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020\u0017H\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020+H\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020_H\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020<H\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u0082\u0001H\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u008f\u0001H\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u008d\u0001H\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u0087\u0001H\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u0089\u0001H\u0002J\r\u0010\u00ab\u0001\u001a\u00020\f*\u00020\u001eH\u0002J\u000e\u0010\u00ab\u0001\u001a\u00020\f*\u00030\u0092\u0001H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ae\u0001"}, d2={"Lgraphics/glimpse/GlimpseAdapter;", "", "gles", "Lcom/jogamp/opengl/GL2ES2;", "(Lcom/jogamp/opengl/GL2ES2;)V", "getGles$core", "()Lcom/jogamp/opengl/GL2ES2;", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "booleanOf", "", "value", "", "framebufferStatusOf", "Lgraphics/glimpse/framebuffers/FramebufferStatus;", "glActiveTexture", "", "textureIndex", "glAttachShader", "programHandle", "shaderHandle", "glBindBuffer", "type", "Lgraphics/glimpse/buffers/BufferType;", "bufferHandle", "glBindFramebuffer", "framebufferHandle", "glBindRenderbuffer", "renderbufferHandle", "glBindTexture", "Lgraphics/glimpse/textures/TextureType;", "textureHandle", "glBlendingColor", "color", "Lgraphics/glimpse/types/Vec4;", "glBlendingFunction", "sourceFactor", "Lgraphics/glimpse/BlendingFactorFunction;", "destinationFactor", "glBufferData", "data", "Lgraphics/glimpse/buffers/FloatBufferData;", "usage", "Lgraphics/glimpse/buffers/BufferUsage;", "Lgraphics/glimpse/buffers/IntBufferData;", "glCheckFramebufferStatus", "glClear", "buffers", "", "Lgraphics/glimpse/ClearableBufferType;", "([Lgraphics/glimpse/ClearableBufferType;)V", "glClearColor", "Lgraphics/glimpse/types/Vec3;", "glClearDepth", "depth", "", "glCompileShader", "glCreateProgram", "glCreateShader", "shaderType", "Lgraphics/glimpse/shaders/ShaderType;", "glCullFace", "faceCullingMode", "Lgraphics/glimpse/FaceCullingMode;", "glDeleteBuffers", "bufferHandles", "", "glDeleteFramebuffers", "framebufferHandles", "glDeleteProgram", "glDeleteRenderbuffers", "renderbufferHandles", "glDeleteShader", "glDeleteTextures", "textureHandles", "glDepthTest", "depthTestFunction", "Lgraphics/glimpse/DepthTestFunction;", "glDisableBlending", "glDisableLineSmooth", "glDisableProgramPointSize", "glDisableVertexAttribArray", "location", "glDrawArrays", "mode", "Lgraphics/glimpse/DrawingMode;", "count", "offset", "glDrawElements", "glEnableBlending", "glEnableLineSmooth", "glEnableProgramPointSize", "glEnableVertexAttribArray", "glFramebufferRenderbuffer", "attachmentType", "Lgraphics/glimpse/framebuffers/FramebufferAttachmentType;", "glFramebufferTexture2D", "textureType", "glGenBuffers", "glGenFramebuffers", "glGenRenderbuffers", "glGenTextures", "glGenerateMipmap", "glGetAttributeLocation", "name", "", "glGetInteger", "parameter", "glGetProgramDeleteStatus", "glGetProgramInfoLog", "glGetProgramLinkStatus", "glGetProgramValidateStatus", "glGetShaderCompileStatus", "glGetShaderDeleteStatus", "glGetShaderInfoLog", "glGetUniformLocation", "glLineWidth", "lineWidth", "glLinkProgram", "glMaxTextureSize", "glReadPixels", "", "x", "y", "width", "height", "format", "Lgraphics/glimpse/PixelFormat;", "glRenderbufferStorage", "internalFormat", "Lgraphics/glimpse/textures/TextureInternalFormat;", "glShaderSource", "source", "glTexImage2D", "pixelFormat", "Lgraphics/glimpse/textures/TexturePixelFormat;", "pixelType", "Lgraphics/glimpse/textures/TexturePixelType;", "pixelData", "glTexParameterFilter", "minFilter", "Lgraphics/glimpse/textures/TextureMinFilter;", "magFilter", "Lgraphics/glimpse/textures/TextureMagFilter;", "glTexParameterWrap", "wrapS", "Lgraphics/glimpse/textures/TextureWrap;", "wrapT", "glTextureIndices", "Lkotlin/ranges/IntRange;", "glUniform", "Lgraphics/glimpse/types/Vec2;", "values", "Lgraphics/glimpse/types/Mat2;", "transpose", "(I[Lgraphics/glimpse/types/Mat2;Z)V", "Lgraphics/glimpse/types/Mat3;", "(I[Lgraphics/glimpse/types/Mat3;Z)V", "Lgraphics/glimpse/types/Mat4;", "(I[Lgraphics/glimpse/types/Mat4;Z)V", "(I[Lgraphics/glimpse/types/Vec2;)V", "(I[Lgraphics/glimpse/types/Vec3;)V", "(I[Lgraphics/glimpse/types/Vec4;)V", "", "glUseProgram", "glValidateProgram", "glVertexAttribPointer", "vectorSize", "normalized", "stride", "glViewport", "toInt", "(Lgraphics/glimpse/DepthTestFunction;)Ljava/lang/Integer;", "(Lgraphics/glimpse/FaceCullingMode;)Ljava/lang/Integer;", "core"})
public final class GlimpseAdapter {
    @NotNull
    private final GL2ES2 gles;
    @NotNull
    private final GlimpseLogger logger;

    public GlimpseAdapter(@NotNull GL2ES2 gles) {
        Intrinsics.checkNotNullParameter((Object)gles, (String)"gles");
        this.gles = gles;
        this.logger = GlimpseLogger.Companion.create(this);
    }

    @NotNull
    public final GL2ES2 getGles$core() {
        return this.gles;
    }

    public final boolean booleanOf(int value) {
        return value != 0;
    }

    public final void glClearColor(@NotNull Vec3 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.logger.debug("Setting clear color: " + color);
        this.gles.glClearColor(color.getR(), color.getG(), color.getB(), 1.0f);
    }

    public final void glClearColor(@NotNull Vec4 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.logger.debug("Setting clear color: " + color);
        this.gles.glClearColor(color.getR(), color.getG(), color.getB(), color.getA());
    }

    public final void glClearDepth(float depth) {
        this.logger.debug("Setting clear depth: " + depth);
        this.gles.glClearDepthf(depth);
    }

    public final void glDepthTest(@NotNull DepthTestFunction depthTestFunction) {
        Intrinsics.checkNotNullParameter((Object)((Object)depthTestFunction), (String)"depthTestFunction");
        this.logger.debug("Setting depth test function: " + depthTestFunction);
        if (depthTestFunction.isDepthTestEnabled()) {
            this.gles.glEnable(2929);
        } else {
            this.gles.glDisable(2929);
        }
        Integer n = this.toInt(depthTestFunction);
        if (n != null) {
            int depthFunc = ((Number)n).intValue();
            boolean bl = false;
            this.getGles$core().glDepthFunc(depthFunc);
        }
    }

    private final Integer toInt(DepthTestFunction $this$toInt) {
        Integer n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toInt.ordinal()]) {
            case 1: {
                n = null;
                break;
            }
            case 2: {
                n = 512;
                break;
            }
            case 3: {
                n = 513;
                break;
            }
            case 4: {
                n = 514;
                break;
            }
            case 5: {
                n = 515;
                break;
            }
            case 6: {
                n = 516;
                break;
            }
            case 7: {
                n = 517;
                break;
            }
            case 8: {
                n = 518;
                break;
            }
            case 9: {
                n = 519;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glCullFace(@NotNull FaceCullingMode faceCullingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)faceCullingMode), (String)"faceCullingMode");
        this.logger.debug("Setting face culling mode: " + faceCullingMode);
        if (faceCullingMode.isFaceCullingEnabled()) {
            this.gles.glEnable(2884);
        } else {
            this.gles.glDisable(2884);
        }
        Integer n = this.toInt(faceCullingMode);
        if (n != null) {
            int depthFunc = ((Number)n).intValue();
            boolean bl = false;
            this.getGles$core().glDepthFunc(depthFunc);
        }
    }

    private final Integer toInt(FaceCullingMode $this$toInt) {
        Integer n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toInt.ordinal()]) {
            case 1: {
                n = null;
                break;
            }
            case 2: {
                n = 1028;
                break;
            }
            case 3: {
                n = 1029;
                break;
            }
            case 4: {
                n = 1032;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glEnableBlending() {
        this.gles.glEnable(3042);
    }

    public final void glDisableBlending() {
        this.gles.glDisable(3042);
    }

    public final void glBlendingFunction(@NotNull BlendingFactorFunction sourceFactor, @NotNull BlendingFactorFunction destinationFactor) {
        Intrinsics.checkNotNullParameter((Object)((Object)sourceFactor), (String)"sourceFactor");
        Intrinsics.checkNotNullParameter((Object)((Object)destinationFactor), (String)"destinationFactor");
        this.gles.glBlendFunc(this.toInt(sourceFactor), this.toInt(destinationFactor));
    }

    private final int toInt(BlendingFactorFunction $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toInt.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 768;
                break;
            }
            case 4: {
                n = 769;
                break;
            }
            case 5: {
                n = 774;
                break;
            }
            case 6: {
                n = 775;
                break;
            }
            case 7: {
                n = 770;
                break;
            }
            case 8: {
                n = 771;
                break;
            }
            case 9: {
                n = 772;
                break;
            }
            case 10: {
                n = 773;
                break;
            }
            case 11: {
                n = 32769;
                break;
            }
            case 12: {
                n = 32770;
                break;
            }
            case 13: {
                n = 32771;
                break;
            }
            case 14: {
                n = 32772;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glBlendingColor(@NotNull Vec4 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.gles.glBlendColor(color.getR(), color.getG(), color.getB(), color.getA());
    }

    public final void glEnableLineSmooth() {
        this.gles.glEnable(2848);
    }

    public final void glDisableLineSmooth() {
        this.gles.glDisable(2848);
    }

    public final void glLineWidth(float lineWidth) {
        this.gles.glLineWidth(lineWidth);
    }

    public final void glEnableProgramPointSize() {
        this.gles.glEnable(34370);
    }

    public final void glDisableProgramPointSize() {
        this.gles.glDisable(34370);
    }

    public final void glViewport(int x, int y, int width, int height) {
        this.logger.debug("Setting viewport: x=" + x + ", y=" + y + ", width=" + width + ", height=" + height);
        this.gles.glViewport(x, y, width, height);
    }

    public static /* synthetic */ void glViewport$default(GlimpseAdapter glimpseAdapter, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        glimpseAdapter.glViewport(n, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    public final void glClear(ClearableBufferType ... buffers) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        if (buffers.length == 0) {
            return;
        }
        ClearableBufferType[] clearableBufferTypeArray = buffers;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        int $i$f$mapTo = 0;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void clearTarget;
            void var11_13 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toInt((ClearableBufferType)clearTarget));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
            int a = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            accumulator$iv = a | b;
        }
        gL2ES2.glClear(((Number)accumulator$iv).intValue());
    }

    private final int toInt(ClearableBufferType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$3[$this$toInt.ordinal()]) {
            case 1: {
                n = 16384;
                break;
            }
            case 2: {
                n = 256;
                break;
            }
            case 3: {
                n = 1024;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glGenBuffers(@NotNull int[] bufferHandles) {
        Intrinsics.checkNotNullParameter((Object)bufferHandles, (String)"bufferHandles");
        this.gles.glGenBuffers(bufferHandles.length, bufferHandles, 0);
    }

    public final void glBindBuffer(@NotNull BufferType type, int bufferHandle) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.gles.glBindBuffer(this.toInt(type), bufferHandle);
    }

    private final int toInt(BufferType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toInt.ordinal()]) {
            case 1: {
                n = 34962;
                break;
            }
            case 2: {
                n = 34963;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glBufferData(@NotNull BufferType type, @NotNull IntBufferData data, @NotNull BufferUsage usage) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        this.gles.glBufferData(this.toInt(type), (long)data.getSizeInBytes(), (Buffer)data.getNioBuffer$core(), this.toInt(usage));
    }

    private final int toInt(BufferUsage $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toInt.ordinal()]) {
            case 1: {
                n = 35040;
                break;
            }
            case 2: {
                n = 35044;
                break;
            }
            case 3: {
                n = 35048;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glBufferData(@NotNull BufferType type, @NotNull FloatBufferData data, @NotNull BufferUsage usage) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        this.gles.glBufferData(this.toInt(type), (long)data.getSizeInBytes(), (Buffer)data.getNioBuffer$core(), this.toInt(usage));
    }

    public final void glDeleteBuffers(@NotNull int[] bufferHandles) {
        Intrinsics.checkNotNullParameter((Object)bufferHandles, (String)"bufferHandles");
        this.gles.glDeleteBuffers(bufferHandles.length, bufferHandles, 0);
    }

    public final void glGenFramebuffers(@NotNull int[] framebufferHandles) {
        Intrinsics.checkNotNullParameter((Object)framebufferHandles, (String)"framebufferHandles");
        this.gles.glGenFramebuffers(framebufferHandles.length, framebufferHandles, 0);
    }

    public final void glBindFramebuffer(int framebufferHandle) {
        this.gles.glBindFramebuffer(36160, framebufferHandle);
    }

    public final void glFramebufferRenderbuffer(@NotNull FramebufferAttachmentType attachmentType, int renderbufferHandle) {
        Intrinsics.checkNotNullParameter((Object)((Object)attachmentType), (String)"attachmentType");
        this.gles.glFramebufferRenderbuffer(36160, this.toInt(attachmentType), 36161, renderbufferHandle);
    }

    private final int toInt(FramebufferAttachmentType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toInt.ordinal()]) {
            case 1: {
                n = 36064;
                break;
            }
            case 2: {
                n = 36096;
                break;
            }
            case 3: {
                n = 36128;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glFramebufferTexture2D(@NotNull FramebufferAttachmentType attachmentType, @NotNull TextureType textureType, int textureHandle) {
        Intrinsics.checkNotNullParameter((Object)((Object)attachmentType), (String)"attachmentType");
        Intrinsics.checkNotNullParameter((Object)((Object)textureType), (String)"textureType");
        this.gles.glFramebufferTexture2D(36160, this.toInt(attachmentType), this.toInt(textureType), textureHandle, 0);
    }

    @NotNull
    public final FramebufferStatus glCheckFramebufferStatus() {
        return this.framebufferStatusOf(this.gles.glCheckFramebufferStatus(36160));
    }

    private final FramebufferStatus framebufferStatusOf(int value) {
        FramebufferStatus framebufferStatus;
        switch (value) {
            case 36053: {
                framebufferStatus = FramebufferStatus.COMPLETE;
                break;
            }
            case 36054: {
                framebufferStatus = FramebufferStatus.INCOMPLETE_ATTACHMENT;
                break;
            }
            case 36055: {
                framebufferStatus = FramebufferStatus.INCOMPLETE_MISSING_ATTACHMENT;
                break;
            }
            case 36061: {
                framebufferStatus = FramebufferStatus.UNSUPPORTED;
                break;
            }
            case 36182: {
                framebufferStatus = FramebufferStatus.INCOMPLETE_MULTISAMPLE;
                break;
            }
            default: {
                framebufferStatus = FramebufferStatus.UNKNOWN_STATUS;
            }
        }
        return framebufferStatus;
    }

    public final void glDeleteFramebuffers(@NotNull int[] framebufferHandles) {
        Intrinsics.checkNotNullParameter((Object)framebufferHandles, (String)"framebufferHandles");
        this.gles.glDeleteFramebuffers(framebufferHandles.length, framebufferHandles, 0);
    }

    public final void glGenRenderbuffers(@NotNull int[] renderbufferHandles) {
        Intrinsics.checkNotNullParameter((Object)renderbufferHandles, (String)"renderbufferHandles");
        this.gles.glGenRenderbuffers(renderbufferHandles.length, renderbufferHandles, 0);
    }

    public final void glBindRenderbuffer(int renderbufferHandle) {
        this.gles.glBindRenderbuffer(36161, renderbufferHandle);
    }

    public final void glRenderbufferStorage(@NotNull TextureInternalFormat internalFormat, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)((Object)internalFormat), (String)"internalFormat");
        this.gles.glRenderbufferStorage(36161, this.toInt(internalFormat), width, height);
    }

    public final void glDeleteRenderbuffers(@NotNull int[] renderbufferHandles) {
        Intrinsics.checkNotNullParameter((Object)renderbufferHandles, (String)"renderbufferHandles");
        this.gles.glDeleteRenderbuffers(renderbufferHandles.length, renderbufferHandles, 0);
    }

    public final void glGenTextures(@NotNull int[] textureHandles) {
        Intrinsics.checkNotNullParameter((Object)textureHandles, (String)"textureHandles");
        this.gles.glGenTextures(textureHandles.length, textureHandles, 0);
    }

    public final void glBindTexture(@NotNull TextureType type, int textureHandle) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.gles.glBindTexture(this.toInt(type), textureHandle);
    }

    private final int toInt(TextureType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toInt.ordinal()]) {
            case 1: {
                n = 3553;
                break;
            }
            case 2: {
                n = 34067;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glTexImage2D(@NotNull TextureInternalFormat internalFormat, int width, int height, @NotNull TexturePixelFormat pixelFormat, @NotNull TexturePixelType pixelType, @Nullable byte[] pixelData) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)((Object)internalFormat), (String)"internalFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelFormat), (String)"pixelFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelType), (String)"pixelType");
        if (pixelData == null) {
            byteBuffer = null;
        } else {
            ByteBuffer byteBuffer2;
            byte[] array = pixelData;
            boolean bl = false;
            ByteBuffer $this$glTexImage2D_u24lambda_u2d5_u24lambda_u2d4 = byteBuffer2 = ByteBuffer.allocateDirect(array.length);
            boolean bl2 = false;
            $this$glTexImage2D_u24lambda_u2d5_u24lambda_u2d4.put(array);
            byteBuffer = byteBuffer2;
        }
        ByteBuffer pixelDataBuffer = byteBuffer;
        this.gles.glTexImage2D(3553, 0, this.toInt(internalFormat), width, height, 0, this.toInt(pixelFormat), this.toInt(pixelType), (Buffer)pixelDataBuffer);
    }

    private final int toInt(TextureInternalFormat $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$8[$this$toInt.ordinal()]) {
            case 1: {
                n = 6402;
                break;
            }
            case 2: {
                n = 6407;
                break;
            }
            case 3: {
                n = 6408;
                break;
            }
            case 4: {
                n = 34843;
                break;
            }
            case 5: {
                n = 34842;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int toInt(TexturePixelFormat $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$9[$this$toInt.ordinal()]) {
            case 1: {
                n = 6407;
                break;
            }
            case 2: {
                n = 6408;
                break;
            }
            case 3: {
                n = 6402;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int toInt(TexturePixelType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$10[$this$toInt.ordinal()]) {
            case 1: {
                n = 5121;
                break;
            }
            case 2: {
                n = 5120;
                break;
            }
            case 3: {
                n = 5123;
                break;
            }
            case 4: {
                n = 5122;
                break;
            }
            case 5: {
                n = 5125;
                break;
            }
            case 6: {
                n = 5124;
                break;
            }
            case 7: {
                n = 5126;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final int glMaxTextureSize(@NotNull TextureType type) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$7[type.ordinal()]) {
            case 1: {
                n = this.glGetInteger(3379);
                break;
            }
            case 2: {
                n = this.glGetInteger(34076);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int glGetInteger(int parameter) {
        int[] result = new int[1];
        this.gles.glGetIntegerv(parameter, result, 0);
        return ArraysKt.first((int[])result);
    }

    public final void glGenerateMipmap(@NotNull TextureType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.gles.glGenerateMipmap(this.toInt(type));
    }

    public final void glTexParameterFilter(@NotNull TextureType type, @NotNull TextureMinFilter minFilter, @NotNull TextureMagFilter magFilter) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)minFilter), (String)"minFilter");
        Intrinsics.checkNotNullParameter((Object)((Object)magFilter), (String)"magFilter");
        this.gles.glTexParameteri(this.toInt(type), 10241, this.toInt(minFilter));
        this.gles.glTexParameteri(this.toInt(type), 10240, this.toInt(magFilter));
    }

    private final int toInt(TextureMinFilter $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$11[$this$toInt.ordinal()]) {
            case 1: {
                n = 9728;
                break;
            }
            case 2: {
                n = 9729;
                break;
            }
            case 3: {
                n = 9984;
                break;
            }
            case 4: {
                n = 9985;
                break;
            }
            case 5: {
                n = 9986;
                break;
            }
            case 6: {
                n = 9987;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int toInt(TextureMagFilter $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$12[$this$toInt.ordinal()]) {
            case 1: {
                n = 9728;
                break;
            }
            case 2: {
                n = 9729;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glTexParameterWrap(@NotNull TextureType type, @NotNull TextureWrap wrapS, @NotNull TextureWrap wrapT) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapS), (String)"wrapS");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapT), (String)"wrapT");
        this.gles.glTexParameteri(this.toInt(type), 10242, this.toInt(wrapS));
        this.gles.glTexParameteri(this.toInt(type), 10243, this.toInt(wrapT));
    }

    private final int toInt(TextureWrap $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$13[$this$toInt.ordinal()]) {
            case 1: {
                n = 33071;
                break;
            }
            case 2: {
                n = 10497;
                break;
            }
            case 3: {
                n = 33648;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glDeleteTextures(@NotNull int[] textureHandles) {
        Intrinsics.checkNotNullParameter((Object)textureHandles, (String)"textureHandles");
        this.gles.glDeleteTextures(textureHandles.length, textureHandles, 0);
    }

    public final void glActiveTexture(int textureIndex) {
        this.gles.glActiveTexture(33984 + textureIndex);
    }

    @NotNull
    public final IntRange glTextureIndices() {
        return RangesKt.until((int)0, (int)this.glGetInteger(35661));
    }

    public final int glCreateShader(@NotNull ShaderType shaderType) {
        Intrinsics.checkNotNullParameter((Object)((Object)shaderType), (String)"shaderType");
        return this.gles.glCreateShader(this.toInt(shaderType));
    }

    private final int toInt(ShaderType $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$14[$this$toInt.ordinal()]) {
            case 1: {
                n = 35633;
                break;
            }
            case 2: {
                n = 35632;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void glShaderSource(int shaderHandle, @NotNull String source) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String[] sources;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String[] stringArray = new String[]{source};
        stringArray = sources = stringArray;
        String[] stringArray2 = sources;
        int n = 1;
        int n2 = shaderHandle;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var13_17 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.length());
        }
        collection = (List)destination$iv$iv;
        gL2ES2.glShaderSource(n2, n, stringArray2, CollectionsKt.toIntArray((Collection)collection), 0);
    }

    public final void glCompileShader(int shaderHandle) {
        this.gles.glCompileShader(shaderHandle);
    }

    public final boolean glGetShaderCompileStatus(int shaderHandle) {
        int[] output = new int[1];
        this.gles.glGetShaderiv(shaderHandle, 35713, output, 0);
        return this.booleanOf(ArraysKt.first((int[])output));
    }

    @NotNull
    public final String glGetShaderInfoLog(int shaderHandle) {
        int[] logLength = new int[1];
        this.gles.glGetShaderiv(shaderHandle, 35716, logLength, 0);
        byte[] log = new byte[ArraysKt.first((int[])logLength)];
        this.gles.glGetShaderInfoLog(shaderHandle, ArraysKt.first((int[])logLength), logLength, 0, log, 0);
        return StringsKt.decodeToString((byte[])log);
    }

    public final void glDeleteShader(int shaderHandle) {
        this.gles.glDeleteShader(shaderHandle);
    }

    public final boolean glGetShaderDeleteStatus(int shaderHandle) {
        int[] output = new int[1];
        this.gles.glGetShaderiv(shaderHandle, 35712, output, 0);
        return this.booleanOf(ArraysKt.first((int[])output));
    }

    public final int glCreateProgram() {
        return this.gles.glCreateProgram();
    }

    public final void glAttachShader(int programHandle, int shaderHandle) {
        this.gles.glAttachShader(programHandle, shaderHandle);
    }

    public final void glLinkProgram(int programHandle) {
        this.gles.glLinkProgram(programHandle);
    }

    public final boolean glGetProgramLinkStatus(int programHandle) {
        int[] output = new int[1];
        this.gles.glGetProgramiv(programHandle, 35714, output, 0);
        return this.booleanOf(ArraysKt.first((int[])output));
    }

    @NotNull
    public final String glGetProgramInfoLog(int programHandle) {
        int[] logLength = new int[1];
        this.gles.glGetProgramiv(programHandle, 35716, logLength, 0);
        byte[] log = new byte[ArraysKt.first((int[])logLength)];
        this.gles.glGetProgramInfoLog(programHandle, ArraysKt.first((int[])logLength), logLength, 0, log, 0);
        return StringsKt.decodeToString((byte[])log);
    }

    public final void glValidateProgram(int programHandle) {
        this.gles.glValidateProgram(programHandle);
    }

    public final boolean glGetProgramValidateStatus(int programHandle) {
        int[] output = new int[1];
        this.gles.glGetProgramiv(programHandle, 35715, output, 0);
        return this.booleanOf(ArraysKt.first((int[])output));
    }

    public final void glUseProgram(int programHandle) {
        this.gles.glUseProgram(programHandle);
    }

    public final void glDeleteProgram(int programHandle) {
        this.gles.glDeleteProgram(programHandle);
    }

    public final boolean glGetProgramDeleteStatus(int programHandle) {
        int[] output = new int[1];
        this.gles.glGetProgramiv(programHandle, 35712, output, 0);
        return this.booleanOf(ArraysKt.first((int[])output));
    }

    public final int glGetUniformLocation(int programHandle, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.gles.glGetUniformLocation(programHandle, name);
    }

    public final int glGetAttributeLocation(int programHandle, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.gles.glGetAttribLocation(programHandle, name);
    }

    public final void glUniform(int location, boolean value) {
        this.gles.glUniform1i(location, value ? 1 : 0);
    }

    public final void glUniform(int location, int value) {
        this.gles.glUniform1i(location, value);
    }

    public final void glUniform(int location, float value) {
        this.gles.glUniform1f(location, value);
    }

    public final void glUniform(int location, @NotNull Vec2 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.gles.glUniform2f(location, value.getX(), value.getY());
    }

    public final void glUniform(int location, @NotNull Vec3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.gles.glUniform3f(location, value.getX(), value.getY(), value.getZ());
    }

    public final void glUniform(int location, @NotNull Vec4 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.gles.glUniform4f(location, value.getX(), value.getY(), value.getZ(), value.getW());
    }

    public final void glUniform(int location, int ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.gles.glUniform1iv(location, values.length, values, 0);
    }

    public final void glUniform(int location, float ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.gles.glUniform1fv(location, values.length, values, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, Vec2 ... values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Vec2[] vec2Array = values;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.toList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniform2fv(n2, n, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, Vec3 ... values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Vec3[] vec3Array = values;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.toList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniform3fv(n2, n, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, Vec4 ... values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Vec4[] vec4Array = values;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.toList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniform4fv(n2, n, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, @NotNull Mat2[] values, boolean transpose2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Mat2[] mat2Array = values;
        boolean bl = transpose2;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var6_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getElements$core();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniformMatrix2fv(n2, n, bl, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    public static /* synthetic */ void glUniform$default(GlimpseAdapter glimpseAdapter, int n, Mat2[] mat2Array, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        glimpseAdapter.glUniform(n, mat2Array, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, @NotNull Mat3[] values, boolean transpose2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Mat3[] mat3Array = values;
        boolean bl = transpose2;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var6_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getElements$core();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniformMatrix3fv(n2, n, bl, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    public static /* synthetic */ void glUniform$default(GlimpseAdapter glimpseAdapter, int n, Mat3[] mat3Array, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        glimpseAdapter.glUniform(n, mat3Array, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void glUniform(int location, @NotNull Mat4[] values, boolean transpose2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Mat4[] mat4Array = values;
        boolean bl = transpose2;
        int n = values.length;
        int n2 = location;
        GL2ES2 gL2ES2 = this.gles;
        boolean $i$f$flatMap = false;
        void var6_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getElements$core();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gL2ES2.glUniformMatrix4fv(n2, n, bl, CollectionsKt.toFloatArray((Collection)list), 0);
    }

    public static /* synthetic */ void glUniform$default(GlimpseAdapter glimpseAdapter, int n, Mat4[] mat4Array, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        glimpseAdapter.glUniform(n, mat4Array, bl);
    }

    public final void glEnableVertexAttribArray(int location) {
        this.gles.glEnableVertexAttribArray(location);
    }

    public final void glDisableVertexAttribArray(int location) {
        this.gles.glDisableVertexAttribArray(location);
    }

    public final void glVertexAttribPointer(int location, int vectorSize, boolean normalized, int stride, int offset) {
        this.gles.glVertexAttribPointer(location, vectorSize, 5126, normalized, stride, (long)offset);
    }

    public static /* synthetic */ void glVertexAttribPointer$default(GlimpseAdapter glimpseAdapter, int n, int n2, boolean bl, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            bl = false;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        glimpseAdapter.glVertexAttribPointer(n, n2, bl, n3, n4);
    }

    public final void glDrawArrays(@NotNull DrawingMode mode, int count, int offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.gles.glDrawArrays(this.toInt(mode), offset, count);
    }

    public static /* synthetic */ void glDrawArrays$default(GlimpseAdapter glimpseAdapter, DrawingMode drawingMode, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        glimpseAdapter.glDrawArrays(drawingMode, n, n2);
    }

    private final int toInt(DrawingMode $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$15[$this$toInt.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final void glDrawElements(@NotNull DrawingMode mode, int count, int offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.gles.glDrawElements(this.toInt(mode), count, 5125, (long)offset);
    }

    public static /* synthetic */ void glDrawElements$default(GlimpseAdapter glimpseAdapter, DrawingMode drawingMode, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        glimpseAdapter.glDrawElements(drawingMode, n, n2);
    }

    @NotNull
    public final byte[] glReadPixels(int x, int y, int width, int height, @NotNull PixelFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        int bytesCount = width * height * format.getBytesPerPixel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytesCount);
        this.gles.glReadPixels(x, y, width, height, this.toInt(format), 5121, (Buffer)buffer);
        byte[] output = new byte[bytesCount];
        buffer.rewind();
        buffer.get(output);
        return output;
    }

    public static /* synthetic */ byte[] glReadPixels$default(GlimpseAdapter glimpseAdapter, int n, int n2, int n3, int n4, PixelFormat pixelFormat, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            pixelFormat = PixelFormat.RGBA;
        }
        return glimpseAdapter.glReadPixels(n, n2, n3, n4, pixelFormat);
    }

    private final int toInt(PixelFormat $this$toInt) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$16[$this$toInt.ordinal()]) {
            case 1: {
                n = 6406;
                break;
            }
            case 2: {
                n = 6407;
                break;
            }
            case 3: {
                n = 6408;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;
        public static final /* synthetic */ int[] $EnumSwitchMapping$6;
        public static final /* synthetic */ int[] $EnumSwitchMapping$7;
        public static final /* synthetic */ int[] $EnumSwitchMapping$8;
        public static final /* synthetic */ int[] $EnumSwitchMapping$9;
        public static final /* synthetic */ int[] $EnumSwitchMapping$10;
        public static final /* synthetic */ int[] $EnumSwitchMapping$11;
        public static final /* synthetic */ int[] $EnumSwitchMapping$12;
        public static final /* synthetic */ int[] $EnumSwitchMapping$13;
        public static final /* synthetic */ int[] $EnumSwitchMapping$14;
        public static final /* synthetic */ int[] $EnumSwitchMapping$15;
        public static final /* synthetic */ int[] $EnumSwitchMapping$16;

        static {
            int[] nArray = new int[DepthTestFunction.values().length];
            nArray[DepthTestFunction.DISABLED.ordinal()] = 1;
            nArray[DepthTestFunction.NEVER.ordinal()] = 2;
            nArray[DepthTestFunction.LESS.ordinal()] = 3;
            nArray[DepthTestFunction.EQUAL.ordinal()] = 4;
            nArray[DepthTestFunction.LESS_OR_EQUAL.ordinal()] = 5;
            nArray[DepthTestFunction.GREATER.ordinal()] = 6;
            nArray[DepthTestFunction.NOT_EQUAL.ordinal()] = 7;
            nArray[DepthTestFunction.GREATER_OR_EQUAL.ordinal()] = 8;
            nArray[DepthTestFunction.ALWAYS.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FaceCullingMode.values().length];
            nArray[FaceCullingMode.DISABLED.ordinal()] = 1;
            nArray[FaceCullingMode.FRONT.ordinal()] = 2;
            nArray[FaceCullingMode.BACK.ordinal()] = 3;
            nArray[FaceCullingMode.FRONT_AND_BACK.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BlendingFactorFunction.values().length];
            nArray[BlendingFactorFunction.ZERO.ordinal()] = 1;
            nArray[BlendingFactorFunction.ONE.ordinal()] = 2;
            nArray[BlendingFactorFunction.SOURCE_COLOR.ordinal()] = 3;
            nArray[BlendingFactorFunction.ONE_MINUS_SOURCE_COLOR.ordinal()] = 4;
            nArray[BlendingFactorFunction.DESTINATION_COLOR.ordinal()] = 5;
            nArray[BlendingFactorFunction.ONE_MINUS_DESTINATION_COLOR.ordinal()] = 6;
            nArray[BlendingFactorFunction.SOURCE_ALPHA.ordinal()] = 7;
            nArray[BlendingFactorFunction.ONE_MINUS_SOURCE_ALPHA.ordinal()] = 8;
            nArray[BlendingFactorFunction.DESTINATION_ALPHA.ordinal()] = 9;
            nArray[BlendingFactorFunction.ONE_MINUS_DESTINATION_ALPHA.ordinal()] = 10;
            nArray[BlendingFactorFunction.CONSTANT_COLOR.ordinal()] = 11;
            nArray[BlendingFactorFunction.ONE_MINUS_CONSTANT_COLOR.ordinal()] = 12;
            nArray[BlendingFactorFunction.CONSTANT_ALPHA.ordinal()] = 13;
            nArray[BlendingFactorFunction.ONE_MINUS_CONSTANT_ALPHA.ordinal()] = 14;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ClearableBufferType.values().length];
            nArray[ClearableBufferType.COLOR_BUFFER.ordinal()] = 1;
            nArray[ClearableBufferType.DEPTH_BUFFER.ordinal()] = 2;
            nArray[ClearableBufferType.STENCIL_BUFFER.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[BufferType.values().length];
            nArray[BufferType.ARRAY_BUFFER.ordinal()] = 1;
            nArray[BufferType.ELEMENT_ARRAY_BUFFER.ordinal()] = 2;
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[BufferUsage.values().length];
            nArray[BufferUsage.STREAM_DRAW.ordinal()] = 1;
            nArray[BufferUsage.STATIC_DRAW.ordinal()] = 2;
            nArray[BufferUsage.DYNAMIC_DRAW.ordinal()] = 3;
            $EnumSwitchMapping$5 = nArray;
            nArray = new int[FramebufferAttachmentType.values().length];
            nArray[FramebufferAttachmentType.COLOR.ordinal()] = 1;
            nArray[FramebufferAttachmentType.DEPTH.ordinal()] = 2;
            nArray[FramebufferAttachmentType.STENCIL.ordinal()] = 3;
            $EnumSwitchMapping$6 = nArray;
            nArray = new int[TextureType.values().length];
            nArray[TextureType.TEXTURE_2D.ordinal()] = 1;
            nArray[TextureType.TEXTURE_CUBE_MAP.ordinal()] = 2;
            $EnumSwitchMapping$7 = nArray;
            nArray = new int[TextureInternalFormat.values().length];
            nArray[TextureInternalFormat.DEPTH_COMPONENT.ordinal()] = 1;
            nArray[TextureInternalFormat.RGB.ordinal()] = 2;
            nArray[TextureInternalFormat.RGBA.ordinal()] = 3;
            nArray[TextureInternalFormat.RGB16F.ordinal()] = 4;
            nArray[TextureInternalFormat.RGBA16F.ordinal()] = 5;
            $EnumSwitchMapping$8 = nArray;
            nArray = new int[TexturePixelFormat.values().length];
            nArray[TexturePixelFormat.RGB.ordinal()] = 1;
            nArray[TexturePixelFormat.RGBA.ordinal()] = 2;
            nArray[TexturePixelFormat.DEPTH_COMPONENT.ordinal()] = 3;
            $EnumSwitchMapping$9 = nArray;
            nArray = new int[TexturePixelType.values().length];
            nArray[TexturePixelType.UNSIGNED_BYTE.ordinal()] = 1;
            nArray[TexturePixelType.BYTE.ordinal()] = 2;
            nArray[TexturePixelType.UNSIGNED_SHORT.ordinal()] = 3;
            nArray[TexturePixelType.SHORT.ordinal()] = 4;
            nArray[TexturePixelType.UNSIGNED_INT.ordinal()] = 5;
            nArray[TexturePixelType.INT.ordinal()] = 6;
            nArray[TexturePixelType.FLOAT.ordinal()] = 7;
            $EnumSwitchMapping$10 = nArray;
            nArray = new int[TextureMinFilter.values().length];
            nArray[TextureMinFilter.NEAREST.ordinal()] = 1;
            nArray[TextureMinFilter.LINEAR.ordinal()] = 2;
            nArray[TextureMinFilter.NEAREST_MIPMAP_NEAREST.ordinal()] = 3;
            nArray[TextureMinFilter.LINEAR_MIPMAP_NEAREST.ordinal()] = 4;
            nArray[TextureMinFilter.NEAREST_MIPMAP_LINEAR.ordinal()] = 5;
            nArray[TextureMinFilter.LINEAR_MIPMAP_LINEAR.ordinal()] = 6;
            $EnumSwitchMapping$11 = nArray;
            nArray = new int[TextureMagFilter.values().length];
            nArray[TextureMagFilter.NEAREST.ordinal()] = 1;
            nArray[TextureMagFilter.LINEAR.ordinal()] = 2;
            $EnumSwitchMapping$12 = nArray;
            nArray = new int[TextureWrap.values().length];
            nArray[TextureWrap.CLAMP_TO_EDGE.ordinal()] = 1;
            nArray[TextureWrap.REPEAT.ordinal()] = 2;
            nArray[TextureWrap.MIRRORED_REPEAT.ordinal()] = 3;
            $EnumSwitchMapping$13 = nArray;
            nArray = new int[ShaderType.values().length];
            nArray[ShaderType.VERTEX_SHADER.ordinal()] = 1;
            nArray[ShaderType.FRAGMENT_SHADER.ordinal()] = 2;
            $EnumSwitchMapping$14 = nArray;
            nArray = new int[DrawingMode.values().length];
            nArray[DrawingMode.POINTS.ordinal()] = 1;
            nArray[DrawingMode.LINES.ordinal()] = 2;
            nArray[DrawingMode.LINE_LOOP.ordinal()] = 3;
            nArray[DrawingMode.LINE_STRIP.ordinal()] = 4;
            nArray[DrawingMode.TRIANGLES.ordinal()] = 5;
            nArray[DrawingMode.TRIANGLE_STRIP.ordinal()] = 6;
            nArray[DrawingMode.TRIANGLE_FAN.ordinal()] = 7;
            $EnumSwitchMapping$15 = nArray;
            nArray = new int[PixelFormat.values().length];
            nArray[PixelFormat.ALPHA.ordinal()] = 1;
            nArray[PixelFormat.RGB.ordinal()] = 2;
            nArray[PixelFormat.RGBA.ordinal()] = 3;
            $EnumSwitchMapping$16 = nArray;
        }
    }
}

