package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.wechat.WechatInfoReqBean;
import global.hh.openapi.sdk.api.bean.wechat.WechatInfoResBean;
import global.hh.openapi.sdk.api.bean.wechat.WechatSendReqBean;
import global.hh.openapi.sdk.api.bean.wechat.WechatSendResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据unionId判断用户是否关注
 * @author: 12869
 * @date: 2021-43-22 10:43:27
 */
public class WechatService extends BaseService {

    public WechatService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 根据unionId判断用户是否关注
     *
     * @author 12869
     * @createDate 2021-43-22 10:43:27
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<WechatInfoResBean> info(BaseRequest<WechatInfoReqBean> req) throws BaseException {
        return call("pub-wechat/user/info", req);
    }
    /**
    * 方法的功能描述: 根据unionId判断用户是否关注
    *
    * @author 12869
    * @createDate 2021-43-22 10:43:27
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<WechatInfoResBean> info(String url,BaseRequest<WechatInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: swisse官方优选根据unionId发送模板消息接口
     *
     * @author 12869
     * @createDate 2021-34-22 16:34:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<WechatSendResBean> send(BaseRequest<WechatSendReqBean> req) throws BaseException {
        return call("pub-wechat/template/swissedtc/send", req);
    }
    /**
    * 方法的功能描述: swisse官方优选根据unionId发送模板消息接口
    *
    * @author 12869
    * @createDate 2021-34-22 16:34:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<WechatSendResBean> send(String url,BaseRequest<WechatSendReqBean> req) throws BaseException {
         return call(url, req);
    }


}
