package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.transaction.TransactionQueryReqBean;
import global.hh.openapi.sdk.api.bean.transaction.TransactionQueryResBean;
import global.hh.openapi.sdk.api.bean.transaction.TransactionValidateReqBean;
import global.hh.openapi.sdk.api.bean.transaction.TransactionValidateResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据手机号，查询会员积分
 * @author: 777771
 * @date: 2023-00-02 16:00:23
 */
public class TransactionService extends BaseService {

    public TransactionService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询会员积分
     *
     * @author 777771
     * @createDate 2023-00-02 16:00:23
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TransactionQueryResBean> query(BaseRequest<TransactionQueryReqBean> req) throws BaseException {
        return call("consumer-cust/member/point/query", req);
    }
    /**
    * 方法的功能描述: 查询会员积分
    *
    * @author 777771
    * @createDate 2023-00-02 16:00:23
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TransactionQueryResBean> query(String url,BaseRequest<TransactionQueryReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 产品校验
     *
     * @author 777771
     * @createDate 2019-39-23 12:39:37
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TransactionValidateResBean> validate(BaseRequest<TransactionValidateReqBean> req) throws BaseException {
        return call("transaction/open/product/validate", req);
    }
    /**
    * 方法的功能描述: 产品校验
    *
    * @author 777771
    * @createDate 2019-39-23 12:39:37
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TransactionValidateResBean> validate(String url,BaseRequest<TransactionValidateReqBean> req) throws BaseException {
         return call(url, req);
    }


}
