package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.tracesource.TracesourceListReqBean;
import global.hh.openapi.sdk.api.bean.tracesource.TracesourceListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据工厂编号获取商品列表
 * @author: 12360
 * @date: 2022-38-07 16:38:06
 */
public class TracesourceService extends BaseService {

    public TracesourceService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 根据工厂编号获取商品列表
     *
     * @author 12360
     * @createDate 2022-38-07 16:38:06
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TracesourceListResBean> list(BaseRequest<TracesourceListReqBean> req) throws BaseException {
        return call("product-mdm/factoryProduct/list", req);
    }
    /**
    * 方法的功能描述: 根据工厂编号获取商品列表
    *
    * @author 12360
    * @createDate 2022-38-07 16:38:06
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TracesourceListResBean> list(String url,BaseRequest<TracesourceListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
