package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.point.PointQueryReqBean;
import global.hh.openapi.sdk.api.bean.point.PointQueryResBean;
import global.hh.openapi.sdk.api.bean.point.PointValidateReqBean;
import global.hh.openapi.sdk.api.bean.point.PointValidateResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据手机号，查询会员积分
 * @author: 12869
 * @date: 2023-59-02 15:59:08
 */
public class PointService extends BaseService {

    public PointService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询会员积分
     *
     * @author 12869
     * @createDate 2023-59-02 15:59:08
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<PointQueryResBean> query(BaseRequest<PointQueryReqBean> req) throws BaseException {
        return call("consumer-cust/member/point/query", req);
    }
    /**
    * 方法的功能描述: 查询会员积分
    *
    * @author 12869
    * @createDate 2023-59-02 15:59:08
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<PointQueryResBean> query(String url,BaseRequest<PointQueryReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 产品校验
     *
     * @author 12531
     * @createDate 2019-07-23 14:07:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<PointValidateResBean> validate(BaseRequest<PointValidateReqBean> req) throws BaseException {
        return call("transaction/open/product/validate", req);
    }
    /**
    * 方法的功能描述: 产品校验
    *
    * @author 12531
    * @createDate 2019-07-23 14:07:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<PointValidateResBean> validate(String url,BaseRequest<PointValidateReqBean> req) throws BaseException {
         return call(url, req);
    }


}
