package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.ftf.FtfQueryFtfActivityListActionReqBean;
import global.hh.openapi.sdk.api.bean.ftf.FtfQueryFtfActivityListActionResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 查询FTF活动
 * @author: 777771
 * @date: 2023-07-21 17:07:28
 */
public class FtfService extends BaseService {

    public FtfService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询FTF活动
     *
     * @author 777771
     * @createDate 2023-07-21 17:07:28
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<FtfQueryFtfActivityListActionResBean> queryFtfActivityListAction(BaseRequest<FtfQueryFtfActivityListActionReqBean> req) throws BaseException {
        return call("samanage/ftf/activity/queryFtfActivityList.action", req);
    }
    /**
    * 方法的功能描述: 查询FTF活动
    *
    * @author 777771
    * @createDate 2023-07-21 17:07:28
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<FtfQueryFtfActivityListActionResBean> queryFtfActivityListAction(String url,BaseRequest<FtfQueryFtfActivityListActionReqBean> req) throws BaseException {
         return call(url, req);
    }


}
