package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.dealerplatform.DealerplatformTmsDeliveryInfosReqBean;
import global.hh.openapi.sdk.api.bean.dealerplatform.DealerplatformTmsDeliveryInfosResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 提供给TMS用于查询会员以及物料订单的物流相关信息
 * @author: 23055
 * @date: 2024-00-23 15:00:07
 */
public class DealerPlatformService extends BaseService {

    public DealerPlatformService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 会员订单&物料订单物流信息查询(TMS专用)
     *
     * @author 23055
     * @createDate 2024-00-23 15:00:07
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<DealerplatformTmsDeliveryInfosResBean> tmsDeliveryInfos(BaseRequest<DealerplatformTmsDeliveryInfosReqBean> req) throws BaseException {
        return call("bed-dp-logistics-service/logistics/openApi/tmsDeliveryInfos", req);
    }
    /**
    * 方法的功能描述: 会员订单&物料订单物流信息查询(TMS专用)
    *
    * @author 23055
    * @createDate 2024-00-23 15:00:07
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<DealerplatformTmsDeliveryInfosResBean> tmsDeliveryInfos(String url,BaseRequest<DealerplatformTmsDeliveryInfosReqBean> req) throws BaseException {
         return call(url, req);
    }


}
