package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicDetailListReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicDetailListResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicGetReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicGetResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicListReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicListResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicMediaGetReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicMediaGetResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicNoticeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicNoticeResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicCodeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicCodeResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicCorpReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicCorpResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicTextcardReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicTextcardResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicByCodeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicByCodeResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicAgentReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicAgentResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicTextReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicTextResBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicDetailReqBean;
import global.hh.openapi.sdk.api.bean.corpbasic.CorpbasicDetailResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 部门管理-获取部门成员详情
 * @author: 12869
 * @date: 2023-45-31 10:45:57
 */
public class CorpBasicService extends BaseService {

    public CorpBasicService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 部门管理-获取部门成员详情
     *
     * @author 12869
     * @createDate 2023-45-31 10:45:57
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicDetailListResBean> detailList(BaseRequest<CorpbasicDetailListReqBean> req) throws BaseException {
        return call("corp-basic-outsite/dept/user/detail/list", req);
    }
    /**
    * 方法的功能描述: 部门管理-获取部门成员详情
    *
    * @author 12869
    * @createDate 2023-45-31 10:45:57
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicDetailListResBean> detailList(String url,BaseRequest<CorpbasicDetailListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 应用管理-获取应用
     *
     * @author 12869
     * @createDate 2023-45-31 10:45:57
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicGetResBean> get(BaseRequest<CorpbasicGetReqBean> req) throws BaseException {
        return call("corp-basic-outsite/agent/get", req);
    }
    /**
    * 方法的功能描述: 应用管理-获取应用
    *
    * @author 12869
    * @createDate 2023-45-31 10:45:57
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicGetResBean> get(String url,BaseRequest<CorpbasicGetReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 部门管理-获取指定部门及其下的子部门
     *
     * @author 12869
     * @createDate 2023-45-31 10:45:57
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicListResBean> list(BaseRequest<CorpbasicListReqBean> req) throws BaseException {
        return call("corp-basic-outsite/dept/list", req);
    }
    /**
    * 方法的功能描述: 部门管理-获取指定部门及其下的子部门
    *
    * @author 12869
    * @createDate 2023-45-31 10:45:57
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicListResBean> list(String url,BaseRequest<CorpbasicListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取临时素材[素材链接最多保存5天]
     *
     * @author 12869
     * @createDate 2023-14-03 11:14:37
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicMediaGetResBean> mediaGet(BaseRequest<CorpbasicMediaGetReqBean> req) throws BaseException {
        return call("corp-basic-outsite/media/get", req);
    }
    /**
    * 方法的功能描述: 获取临时素材[素材链接最多保存5天]
    *
    * @author 12869
    * @createDate 2023-14-03 11:14:37
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicMediaGetResBean> mediaGet(String url,BaseRequest<CorpbasicMediaGetReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送小程序通知消息
     *
     * @author 12869
     * @createDate 2022-33-07 16:33:16
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicNoticeResBean> notice(BaseRequest<CorpbasicNoticeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/miniprogram/notice", req);
    }
    /**
    * 方法的功能描述: 发送小程序通知消息
    *
    * @author 12869
    * @createDate 2022-33-07 16:33:16
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicNoticeResBean> notice(String url,BaseRequest<CorpbasicNoticeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取访问用户身份
     *
     * @author 12869
     * @createDate 2021-59-11 13:59:12
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicCodeResBean> code(BaseRequest<CorpbasicCodeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/get/by/code", req);
    }
    /**
    * 方法的功能描述: 获取访问用户身份
    *
    * @author 12869
    * @createDate 2021-59-11 13:59:12
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicCodeResBean> code(String url,BaseRequest<CorpbasicCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取企业的jsapi_ticket
     *
     * @author 12360
     * @createDate 2022-29-17 16:29:37
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicCorpResBean> corp(BaseRequest<CorpbasicCorpReqBean> req) throws BaseException {
        return call("corp-basic-outsite/jsapiticket/corp", req);
    }
    /**
    * 方法的功能描述: 获取企业的jsapi_ticket
    *
    * @author 12360
    * @createDate 2022-29-17 16:29:37
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicCorpResBean> corp(String url,BaseRequest<CorpbasicCorpReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送应用文本卡片消息
     *
     * @author 12869
     * @createDate 2022-00-23 10:00:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicTextcardResBean> textcard(BaseRequest<CorpbasicTextcardReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/textcard", req);
    }
    /**
    * 方法的功能描述: 发送应用文本卡片消息
    *
    * @author 12869
    * @createDate 2022-00-23 10:00:38
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicTextcardResBean> textcard(String url,BaseRequest<CorpbasicTextcardReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 自建小程序获取访问用户身份
     *
     * @author 12869
     * @createDate 2022-02-22 14:02:17
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicByCodeResBean> byCode(BaseRequest<CorpbasicByCodeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/agentminiapp/by/code", req);
    }
    /**
    * 方法的功能描述: 自建小程序获取访问用户身份
    *
    * @author 12869
    * @createDate 2022-02-22 14:02:17
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicByCodeResBean> byCode(String url,BaseRequest<CorpbasicByCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取应用的jsapi_ticket
     *
     * @author 12869
     * @createDate 2021-43-07 09:43:11
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicAgentResBean> agent(BaseRequest<CorpbasicAgentReqBean> req) throws BaseException {
        return call("corp-basic-outsite/jsapiticket/agent", req);
    }
    /**
    * 方法的功能描述: 获取应用的jsapi_ticket
    *
    * @author 12869
    * @createDate 2021-43-07 09:43:11
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicAgentResBean> agent(String url,BaseRequest<CorpbasicAgentReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送应用文本消息
     *
     * @author 12869
     * @createDate 2021-26-26 09:26:32
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicTextResBean> text(BaseRequest<CorpbasicTextReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/text", req);
    }
    /**
    * 方法的功能描述: 发送应用文本消息
    *
    * @author 12869
    * @createDate 2021-26-26 09:26:32
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicTextResBean> text(String url,BaseRequest<CorpbasicTextReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 读取成员详情
     *
     * @author 12869
     * @createDate 2021-48-25 14:48:13
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicDetailResBean> detail(BaseRequest<CorpbasicDetailReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/detail", req);
    }
    /**
    * 方法的功能描述: 读取成员详情
    *
    * @author 12869
    * @createDate 2021-48-25 14:48:13
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicDetailResBean> detail(String url,BaseRequest<CorpbasicDetailReqBean> req) throws BaseException {
         return call(url, req);
    }


}
