package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.activity.ActivityQueryPointRecycleRankReqBean;
import global.hh.openapi.sdk.api.bean.activity.ActivityQueryPointRecycleRankResBean;
import global.hh.openapi.sdk.api.bean.activity.ActivityQueryCurrentPointRecycleRankReqBean;
import global.hh.openapi.sdk.api.bean.activity.ActivityQueryCurrentPointRecycleRankResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 1、查询大区维度的积分回收排行榜
2、查询办事处维度的积分回收排行榜
3、查询门店维度的积分回收排行榜
 * @author: 3742
 * @date: 2018-39-07 14:39:03
 */
public class ActivityService extends BaseService {

    public ActivityService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询大区办事处门店的积分回收排行榜
     *
     * @author 3742
     * @createDate 2018-39-07 14:39:03
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ActivityQueryPointRecycleRankResBean> queryPointRecycleRank(BaseRequest<ActivityQueryPointRecycleRankReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryPointRecycleRank", req);
    }
    /**
    * 方法的功能描述: 查询大区办事处门店的积分回收排行榜
    *
    * @author 3742
    * @createDate 2018-39-07 14:39:03
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ActivityQueryPointRecycleRankResBean> queryPointRecycleRank(String url,BaseRequest<ActivityQueryPointRecycleRankReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询当前登录的大区办事处门店的积分回收排行榜
     *
     * @author 3742
     * @createDate 2018-44-20 13:44:02
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ActivityQueryCurrentPointRecycleRankResBean> queryCurrentPointRecycleRank(BaseRequest<ActivityQueryCurrentPointRecycleRankReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryCurrentPointRecycleRank", req);
    }
    /**
    * 方法的功能描述: 查询当前登录的大区办事处门店的积分回收排行榜
    *
    * @author 3742
    * @createDate 2018-44-20 13:44:02
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ActivityQueryCurrentPointRecycleRankResBean> queryCurrentPointRecycleRank(String url,BaseRequest<ActivityQueryCurrentPointRecycleRankReqBean> req) throws BaseException {
         return call(url, req);
    }


}
