package global.hh.openapi.sdk.api.bean.proc;


/**
 * @description: 通过工号查询可使用的物料仓列表
 * @author: 12804
 * @date: 2023-52-18 12:52:48
 */
public class ProcPageAvailableStockForOpenReqBean {
    /**
     * 工号
     */
    private String workCode;

    /**
     * 物料仓名称/编码
     */
    private String stockNameCode;

    /**
     * 仓库类型 0:总部仓,1:经销商仓,2:大区/办事处仓,3:终端虚拟仓,4:消费者虚拟仓
     */
    private String stockType;

    /**
     * 经销商ID
     */
    private String dealerId;

    /**
     * 当前页
     */
    private Long current;

    /**
     * 每页大小
     */
    private Long size;

    public ProcPageAvailableStockForOpenReqBean(){
    }

    public ProcPageAvailableStockForOpenReqBean(String workCode,String stockNameCode,String stockType,String dealerId,Long current,Long size){
        this.workCode=workCode;
        this.stockNameCode=stockNameCode;
        this.stockType=stockType;
        this.dealerId=dealerId;
        this.current=current;
        this.size=size;
    }

    public String getWorkCode() {
        return workCode;
    }

    public void setWorkCode(String workCode) {
        this.workCode = workCode;
    }
    public String getStockNameCode() {
        return stockNameCode;
    }

    public void setStockNameCode(String stockNameCode) {
        this.stockNameCode = stockNameCode;
    }
    public String getStockType() {
        return stockType;
    }

    public void setStockType(String stockType) {
        this.stockType = stockType;
    }
    public String getDealerId() {
        return dealerId;
    }

    public void setDealerId(String dealerId) {
        this.dealerId = dealerId;
    }
    public Long getCurrent() {
        return current;
    }

    public void setCurrent(Long current) {
        this.current = current;
    }
    public Long getSize() {
        return size;
    }

    public void setSize(Long size) {
        this.size = size;
    }
}
