package global.hh.openapi.sdk.api.bean.merchant;


/**
 * @description: 根据营销通app token或账号ID
查询登录人的账号基础信息，包含当前登录人所在的大区办事处。

角色类型定义如下：
1	合生元
2	长沙素加
3	Swisse人员
7	店主
8	店长
9	店员
10	综合促销员
11	KOL
12	Feichat
14	Swisse促销员
15	促销教练
38	微客
40	大区药线商务推广员
41	SA育婴顾问
42	品牌大使
43	商超特工
44	经销商业务员
45	业务精英
50	BNC活动精英
51	ANC活动精英
52	联营人员
 * @author: 3742
 * @date: 2018-45-07 11:45:03
 */
public class MerchantQueryAccountInfoReqBean {
    /**
     * 营销通app 登录人 ID，accountId与yxtAppToken不能同时查
     */
    private Long accountId;

    /**
     * 营销通app token，accountId与yxtAppToken不能同时查
     */
    private String yxtAppToken;

    public MerchantQueryAccountInfoReqBean(){
    }

    public MerchantQueryAccountInfoReqBean(Long accountId,String yxtAppToken){
        this.accountId=accountId;
        this.yxtAppToken=yxtAppToken;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getYxtAppToken() {
        return yxtAppToken;
    }

    public void setYxtAppToken(String yxtAppToken) {
        this.yxtAppToken = yxtAppToken;
    }
}
