package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 对外暴露api接口
 * @author: 13351
 * @date: 2019-46-29 12:46:19
 */
public class MemberCallFinishSceneInstanceBean {

    /**
     * 通话实例索引
     */
    private Long callIndex;

    /**
     * 通话记录Id
     */
    private Long callInstanceId;

    /**
     * 任务Id
     */
    private Long callJobId;

    /**
     * 外呼方式，对应主叫号码(线路)类型枚举
     */
    private Long callType;

    /**
     * 主叫用户ID
     */
    private Long callUserId;

    /**
     * 是否回调完成 0：未回调 1：已回调
     */
    private Long callbacked;

    /**
     * 主叫号码
     */
    private String callerPhone;

    /**
     * 通话轮次
     */
    private Long chatRound;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 通话费用，单位（分）
     */
    private Long cost;

    /**
     * 客户Id
     */
    private Long customerId;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerTelephone;

    /**
     * 通话时长
     */
    private Long duration;

    /**
     * 通话结束时间
     */
    private String endTime;

    /**
     * 已完成通话状态枚举，通话完成最终状态，0	已接听1拒接2	无法接通3主叫号码不可用4空号5关机6占线7停机8未接9主叫欠费10	呼损11黑名单
     */
    private Long finishStatus;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 话术名
     */
    private String handlePerson;

    /**
     * 挂机人 0：AI 1：用户
     */
    private Long hangUp;

    /**
     * 所属行业
     */
    private String industry;

    /**
     * 电话任务名称
     */
    private String jobName;

    /**
     * 通话录音（包含Ai和客户）
     */
    private String luyinOssUrl;

    /**
     * 通话记录携带的参数(json字符串)，包含话术变量和自定义参数，用户可以传入自己的变量，百应回调会传回给用户
     */
    private String properties;

    /**
     * 是否已读，产品中的通话记录已读未读状态 0：未读 1：已读
     */
    private Long readStatus;

    /**
     * 机器人Id
     */
    private Long robotDefId;

    /**
     * 场景Id
     */
    private Long sceneDefId;

    /**
     * 场景录音id
     */
    private Long sceneRecordId;

    /**
     * 二次拨打时间
     */
    private String secondaryCallTime;

    /**
     * 二次拨打次数 为0后不进行外呼
     */
    private Long secondaryCallTimes;

    /**
     * 通话开始时间
     */
    private String startTime;

    /**
     * 通话实例状态枚举，0未开始1进行中2已完成
     */
    private Long status;

    /**
     * bug追踪结果
     */
    private String trackResult;

    /**
     * 通话录音（只包含客户）
     */
    private String userLuyinOssUrl;

    public MemberCallFinishSceneInstanceBean(){
    }

    public MemberCallFinishSceneInstanceBean(Long callIndex,Long callInstanceId,Long callJobId,Long callType,Long callUserId,Long callbacked,String callerPhone,Long chatRound,Long companyId,Long cost,Long customerId,String customerName,String customerTelephone,Long duration,String endTime,Long finishStatus,String gmtCreate,String gmtModified,String handlePerson,Long hangUp,String industry,String jobName,String luyinOssUrl,String properties,Long readStatus,Long robotDefId,Long sceneDefId,Long sceneRecordId,String secondaryCallTime,Long secondaryCallTimes,String startTime,Long status,String trackResult,String userLuyinOssUrl){
        this.callIndex=callIndex;
        this.callInstanceId=callInstanceId;
        this.callJobId=callJobId;
        this.callType=callType;
        this.callUserId=callUserId;
        this.callbacked=callbacked;
        this.callerPhone=callerPhone;
        this.chatRound=chatRound;
        this.companyId=companyId;
        this.cost=cost;
        this.customerId=customerId;
        this.customerName=customerName;
        this.customerTelephone=customerTelephone;
        this.duration=duration;
        this.endTime=endTime;
        this.finishStatus=finishStatus;
        this.gmtCreate=gmtCreate;
        this.gmtModified=gmtModified;
        this.handlePerson=handlePerson;
        this.hangUp=hangUp;
        this.industry=industry;
        this.jobName=jobName;
        this.luyinOssUrl=luyinOssUrl;
        this.properties=properties;
        this.readStatus=readStatus;
        this.robotDefId=robotDefId;
        this.sceneDefId=sceneDefId;
        this.sceneRecordId=sceneRecordId;
        this.secondaryCallTime=secondaryCallTime;
        this.secondaryCallTimes=secondaryCallTimes;
        this.startTime=startTime;
        this.status=status;
        this.trackResult=trackResult;
        this.userLuyinOssUrl=userLuyinOssUrl;
    }

    public Long getCallIndex() {
        return callIndex;
    }

    public void setCallIndex(Long callIndex) {
        this.callIndex = callIndex;
    }
    public Long getCallInstanceId() {
        return callInstanceId;
    }

    public void setCallInstanceId(Long callInstanceId) {
        this.callInstanceId = callInstanceId;
    }
    public Long getCallJobId() {
        return callJobId;
    }

    public void setCallJobId(Long callJobId) {
        this.callJobId = callJobId;
    }
    public Long getCallType() {
        return callType;
    }

    public void setCallType(Long callType) {
        this.callType = callType;
    }
    public Long getCallUserId() {
        return callUserId;
    }

    public void setCallUserId(Long callUserId) {
        this.callUserId = callUserId;
    }
    public Long getCallbacked() {
        return callbacked;
    }

    public void setCallbacked(Long callbacked) {
        this.callbacked = callbacked;
    }
    public String getCallerPhone() {
        return callerPhone;
    }

    public void setCallerPhone(String callerPhone) {
        this.callerPhone = callerPhone;
    }
    public Long getChatRound() {
        return chatRound;
    }

    public void setChatRound(Long chatRound) {
        this.chatRound = chatRound;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public Long getCost() {
        return cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getCustomerTelephone() {
        return customerTelephone;
    }

    public void setCustomerTelephone(String customerTelephone) {
        this.customerTelephone = customerTelephone;
    }
    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }
    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
    public Long getFinishStatus() {
        return finishStatus;
    }

    public void setFinishStatus(Long finishStatus) {
        this.finishStatus = finishStatus;
    }
    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    public String getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }
    public String getHandlePerson() {
        return handlePerson;
    }

    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }
    public Long getHangUp() {
        return hangUp;
    }

    public void setHangUp(Long hangUp) {
        this.hangUp = hangUp;
    }
    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }
    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }
    public String getLuyinOssUrl() {
        return luyinOssUrl;
    }

    public void setLuyinOssUrl(String luyinOssUrl) {
        this.luyinOssUrl = luyinOssUrl;
    }
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }
    public Long getReadStatus() {
        return readStatus;
    }

    public void setReadStatus(Long readStatus) {
        this.readStatus = readStatus;
    }
    public Long getRobotDefId() {
        return robotDefId;
    }

    public void setRobotDefId(Long robotDefId) {
        this.robotDefId = robotDefId;
    }
    public Long getSceneDefId() {
        return sceneDefId;
    }

    public void setSceneDefId(Long sceneDefId) {
        this.sceneDefId = sceneDefId;
    }
    public Long getSceneRecordId() {
        return sceneRecordId;
    }

    public void setSceneRecordId(Long sceneRecordId) {
        this.sceneRecordId = sceneRecordId;
    }
    public String getSecondaryCallTime() {
        return secondaryCallTime;
    }

    public void setSecondaryCallTime(String secondaryCallTime) {
        this.secondaryCallTime = secondaryCallTime;
    }
    public Long getSecondaryCallTimes() {
        return secondaryCallTimes;
    }

    public void setSecondaryCallTimes(Long secondaryCallTimes) {
        this.secondaryCallTimes = secondaryCallTimes;
    }
    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }
    public Long getStatus() {
        return status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }
    public String getTrackResult() {
        return trackResult;
    }

    public void setTrackResult(String trackResult) {
        this.trackResult = trackResult;
    }
    public String getUserLuyinOssUrl() {
        return userLuyinOssUrl;
    }

    public void setUserLuyinOssUrl(String userLuyinOssUrl) {
        this.userLuyinOssUrl = userLuyinOssUrl;
    }
}
