package global.hh.openapi.sdk.api.bean.accountservice;


/**
 * @description: 获取HCM职务信息接口
 * @author: 23465
 * @date: 2023-56-15 15:56:26
 */
public class AccountserviceGetJobListReqBean {
    /**
     * 查询方式 true:增量查询（包括新增或变更） false:范围查询 （默认true）
     */
    private Boolean incrementalFlag;

    /**
     * 增量查询开始时间 格式为：yyyy-MM-dd 针对岗位记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String startDate;

    /**
     * 增量查询结束时间 格式为：yyyy-MM-dd 针对岗位记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String endDate;

    /**
     * 岗位ID
     */
    private String pk;

    /**
     * 岗位名称
     */
    private String name;

    /**
     * 岗位状态(0:无效,1:有效)
     */
    private Long status;

    public AccountserviceGetJobListReqBean(){
    }

    public AccountserviceGetJobListReqBean(Boolean incrementalFlag,String startDate,String endDate,String pk,String name,Long status){
        this.incrementalFlag=incrementalFlag;
        this.startDate=startDate;
        this.endDate=endDate;
        this.pk=pk;
        this.name=name;
        this.status=status;
    }

    public Boolean getIncrementalFlag() {
        return incrementalFlag;
    }

    public void setIncrementalFlag(Boolean incrementalFlag) {
        this.incrementalFlag = incrementalFlag;
    }
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public String getPk() {
        return pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getStatus() {
        return status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }
}
