package global.hh.openapi.sdk.utils;

import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.InvalidSignatureException;

import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

/**
 * 方法的功能描述: 签名工具类
 *
 * @param
 * @author 3742
 * @createDate 2018-11-23 16:49
 * @return
 */
public class SignatureUtils {


    /**
     * 方法的功能描述: 生成签名
     *
     * @param
     * @return 返回签名值
     * @author 3742
     * @createDate 2018-11-16 18:26
     */
    public static String generateSignature(Map<String, Object> publicParams, Map<String, Object> businessParams,
                                           String secretKey) throws BaseException {

        //参与计算签名的所有数据
        final Map<String, Object> allMap = new TreeMap();

        //如果业务参数为空，则不参与计算签名， 不为空把业务参数放进allMap
        if (businessParams != null) {
            for (Map.Entry<String, Object> entry : businessParams.entrySet()) {
                if (entry.getValue() == null || StringUtils.isEmpty(entry.getValue().toString())) {
                    continue;
                }
                allMap.put(entry.getKey(), entry.getValue());
            }
        }

        //把公共参数放进allMap
        allMap.putAll(publicParams);

        //对allMap的key 和value进行连接在一起组成一串值
        StringBuffer string = new StringBuffer();
        for (Map.Entry<String, Object> entry : allMap.entrySet()) {
            string.append(entry.getKey()).append(JsonUtils.toJson(entry.getValue()));
        }

        //用secretKey 和上面生成的一串值，和用secretKey连接组成 原始串
        String original = String.format("%s%s%s", secretKey, string.toString(), secretKey);
        //System.out.println("原始串:" + original);

        //对原始串进行哈希计算得到签名值
        String signMethod = (String) publicParams.get("signMethod");
        String signature = "";
        if ("MD5".equals(signMethod)) {
            signature = md5Encode(original);
        } else if ("SHA256".equals(signMethod)) {
            signature = sha256Encode(original);
        } else {
            throw new InvalidSignatureException("暂时不支持" + signMethod + "算法");
        }

        //对签名值全部传承大写
        return signature.toUpperCase();
    }

    /**
     * 方法的功能描述: md5签名算法实现
     *
     * @param
     * @return
     * @author 3742
     * @createDate 2018-11-16 18:27
     */
    private static String md5Encode(String inStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] byteArray = inStr.getBytes("UTF-8");
            byte[] md5Bytes = md5.digest(byteArray);
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; i++) {
                int val = ((int) md5Bytes[i]) & 0xff;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        } catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 方法的功能描述: sha256签名算法实现
     *
     * @param
     * @return
     * @author 3742
     * @createDate 2018-11-16 18:27
     */
    private static String sha256Encode(String inStr) {
        try {
            MessageDigest sha = null;
            try {
                sha = MessageDigest.getInstance("SHA-256");
            } catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
                return "";
            }
            byte[] byteArray = inStr.getBytes("UTF-8");
            byte[] md5Bytes = sha.digest(byteArray);
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; i++) {
                int val = ((int) md5Bytes[i]) & 0xff;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

}
