package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.trading.TradingQueryCustTotalOrderPriceReqBean;
import global.hh.openapi.sdk.api.bean.trading.TradingQueryCustTotalOrderPriceResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 查询用户下单总金额
 * @author: 12869
 * @date: 2024-50-03 16:50:19
 */
public class TradingService extends BaseService {

    public TradingService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询用户下单总金额
     *
     * @author 12869
     * @createDate 2024-50-03 16:50:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<TradingQueryCustTotalOrderPriceResBean> queryCustTotalOrderPrice(BaseRequest<TradingQueryCustTotalOrderPriceReqBean> req) throws BaseException {
        return call("order-platform/open/queryCustTotalOrderPrice", req);
    }
    /**
    * 方法的功能描述: 查询用户下单总金额
    *
    * @author 12869
    * @createDate 2024-50-03 16:50:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<TradingQueryCustTotalOrderPriceResBean> queryCustTotalOrderPrice(String url,BaseRequest<TradingQueryCustTotalOrderPriceReqBean> req) throws BaseException {
         return call(url, req);
    }


}
