package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.promotion.PromotionDecideReqBean;
import global.hh.openapi.sdk.api.bean.promotion.PromotionDecideResBean;
import global.hh.openapi.sdk.api.bean.promotion.PromotionTmallDecideReqBean;
import global.hh.openapi.sdk.api.bean.promotion.PromotionTmallDecideResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 京东渠道新客判断接口
 * @author: 12869
 * @date: 2024-32-27 17:32:17
 */
public class PromotionService extends BaseService {

    public PromotionService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 京东渠道新客判断接口
     *
     * @author 12869
     * @createDate 2024-32-27 17:32:17
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<PromotionDecideResBean> decide(BaseRequest<PromotionDecideReqBean> req) throws BaseException {
        return call("customer-validation-service/new-customer/jd/decide", req);
    }
    /**
    * 方法的功能描述: 京东渠道新客判断接口
    *
    * @author 12869
    * @createDate 2024-32-27 17:32:17
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<PromotionDecideResBean> decide(String url,BaseRequest<PromotionDecideReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 天猫渠道新客判断接口
     *
     * @author 12869
     * @createDate 2024-28-27 17:28:53
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<PromotionTmallDecideResBean> tmallDecide(BaseRequest<PromotionTmallDecideReqBean> req) throws BaseException {
        return call("customer-validation-service/new-customer/tmall/decide", req);
    }
    /**
    * 方法的功能描述: 天猫渠道新客判断接口
    *
    * @author 12869
    * @createDate 2024-28-27 17:28:53
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<PromotionTmallDecideResBean> tmallDecide(String url,BaseRequest<PromotionTmallDecideReqBean> req) throws BaseException {
         return call(url, req);
    }


}
