package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.logistics.LogisticsReceiveJDLogisticsReqBean;
import global.hh.openapi.sdk.api.bean.logistics.LogisticsReceiveJDLogisticsResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 接收 京东、荣庆等第三方推送的物流信息 服务
 * @author: 23055
 * @date: 2021-17-24 14:17:29
 */
public class LogisticsService extends BaseService {

    public LogisticsService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 接收物流推送信息
     *
     * @author 23055
     * @createDate 2021-17-24 14:17:29
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<LogisticsReceiveJDLogisticsResBean> receiveJDLogistics(BaseRequest<LogisticsReceiveJDLogisticsReqBean> req) throws BaseException {
        return call("dealer-platform-logistics/logistics/receiveJDLogistics", req);
    }
    /**
    * 方法的功能描述: 接收物流推送信息
    *
    * @author 23055
    * @createDate 2021-17-24 14:17:29
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<LogisticsReceiveJDLogisticsResBean> receiveJDLogistics(String url,BaseRequest<LogisticsReceiveJDLogisticsReqBean> req) throws BaseException {
         return call(url, req);
    }


}
