package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.bedterminalservice.BedterminalserviceOpenApipotentialterminalReqBean;
import global.hh.openapi.sdk.api.bean.bedterminalservice.BedterminalserviceOpenApipotentialterminalResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 过办事处编码or门店名称获取潜店信息
 * @author: 12457
 * @date: 2023-47-14 22:47:59
 */
public class BedTerminalServiceService extends BaseService {

    public BedTerminalServiceService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 通过办事处编码or门店名称获取潜店
     *
     * @author 12457
     * @createDate 2023-47-14 22:47:59
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedterminalserviceOpenApipotentialterminalResBean> openApipotentialterminal(BaseRequest<BedterminalserviceOpenApipotentialterminalReqBean> req) throws BaseException {
        return call("bed-terminal-service/terminal/openApi/office-code/openApi-potential-terminal", req);
    }
    /**
    * 方法的功能描述: 通过办事处编码or门店名称获取潜店
    *
    * @author 12457
    * @createDate 2023-47-14 22:47:59
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedterminalserviceOpenApipotentialterminalResBean> openApipotentialterminal(String url,BaseRequest<BedterminalserviceOpenApipotentialterminalReqBean> req) throws BaseException {
         return call(url, req);
    }


}
