package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiCityInfoReqBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiCityInfoResBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiCreateTerminalReqBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiCreateTerminalResBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiIncrementReqBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiIncrementResBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiAllReqBean;
import global.hh.openapi.sdk.api.bean.bedaccountterminalmgt.BedaccountterminalmgtOpenApiAllResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据地址获取办事处编码
 * @author: 12457
 * @date: 2023-58-14 09:58:08
 */
public class BedAccountTerminalMgtService extends BaseService {

    public BedAccountTerminalMgtService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 根据地址获取办事处编码
     *
     * @author 12457
     * @createDate 2023-58-14 09:58:08
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedaccountterminalmgtOpenApiCityInfoResBean> openApiCityInfo(BaseRequest<BedaccountterminalmgtOpenApiCityInfoReqBean> req) throws BaseException {
        return call("bed-account-terminal-mgt/terminal/openApi/openApiCityInfo", req);
    }
    /**
    * 方法的功能描述: 根据地址获取办事处编码
    *
    * @author 12457
    * @createDate 2023-58-14 09:58:08
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedaccountterminalmgtOpenApiCityInfoResBean> openApiCityInfo(String url,BaseRequest<BedaccountterminalmgtOpenApiCityInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 开放平台-终端新增
     *
     * @author 12457
     * @createDate 2023-47-14 22:47:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedaccountterminalmgtOpenApiCreateTerminalResBean> openApiCreateTerminal(BaseRequest<BedaccountterminalmgtOpenApiCreateTerminalReqBean> req) throws BaseException {
        return call("account-terminal-mgt/terminal/openApi/openApiCreateTerminal", req);
    }
    /**
    * 方法的功能描述: 开放平台-终端新增
    *
    * @author 12457
    * @createDate 2023-47-14 22:47:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedaccountterminalmgtOpenApiCreateTerminalResBean> openApiCreateTerminal(String url,BaseRequest<BedaccountterminalmgtOpenApiCreateTerminalReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 增量获取终端信息
     *
     * @author 12457
     * @createDate 2023-11-15 14:11:31
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedaccountterminalmgtOpenApiIncrementResBean> openApiIncrement(BaseRequest<BedaccountterminalmgtOpenApiIncrementReqBean> req) throws BaseException {
        return call("bed-account-terminal-mgt/terminal/openApi/openApiIncrement", req);
    }
    /**
    * 方法的功能描述: 增量获取终端信息
    *
    * @author 12457
    * @createDate 2023-11-15 14:11:31
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedaccountterminalmgtOpenApiIncrementResBean> openApiIncrement(String url,BaseRequest<BedaccountterminalmgtOpenApiIncrementReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 全量获取终端信息
     *
     * @author 12457
     * @createDate 2023-11-15 14:11:17
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedaccountterminalmgtOpenApiAllResBean> openApiAll(BaseRequest<BedaccountterminalmgtOpenApiAllReqBean> req) throws BaseException {
        return call("bed-account-terminal-mgt/terminal/openApi/openApiAll", req);
    }
    /**
    * 方法的功能描述: 全量获取终端信息
    *
    * @author 12457
    * @createDate 2023-11-15 14:11:17
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedaccountterminalmgtOpenApiAllResBean> openApiAll(String url,BaseRequest<BedaccountterminalmgtOpenApiAllReqBean> req) throws BaseException {
         return call(url, req);
    }


}
