package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 公共接口：根据手机号码注册会员，会判断是否为新客。
 * @author: 777771
 * @date: 2020-17-05 15:17:17
 */
public class MemberSyncCommonNewCustomerReqBean {
    /**
     * 顾客手机号码，必填。
     */
    private String mobile;

    /**
     * 类型，此处传固定值type=1。必填。
     */
    private Long type;

    /**
     * 顾客性别，-1-性别不详，0-男，1-女
     */
    private Long gender;

    /**
     * 顾客姓名，建议填写。
     */
    private String name;

    /**
     * 宝宝生日时间戳(毫秒)，如无则不需传这个参数。
     */
    private Long birthday;

    /**
     * 宝宝名称，如无则不需传这个参数。
     */
    private String kidName;

    /**
     * 来源，此处传固定值 fromSystem = “POS”。
     */
    private String fromSystem;

    /**
     * 品牌名称， 格式为：品牌名称（大写字母）+”SHM”。 例如：咿呀： YIYA_SHM 。
     */
    private String fromSubSystem;

    /**
     * 此处传customerId=0，或者不传。
     */
    private Long customerId;

    public MemberSyncCommonNewCustomerReqBean(){
    }

    public MemberSyncCommonNewCustomerReqBean(String mobile,Long type,Long gender,String name,Long birthday,String kidName,String fromSystem,String fromSubSystem,Long customerId){
        this.mobile=mobile;
        this.type=type;
        this.gender=gender;
        this.name=name;
        this.birthday=birthday;
        this.kidName=kidName;
        this.fromSystem=fromSystem;
        this.fromSubSystem=fromSubSystem;
        this.customerId=customerId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }
    public Long getGender() {
        return gender;
    }

    public void setGender(Long gender) {
        this.gender = gender;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }
    public String getKidName() {
        return kidName;
    }

    public void setKidName(String kidName) {
        this.kidName = kidName;
    }
    public String getFromSystem() {
        return fromSystem;
    }

    public void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }
    public String getFromSubSystem() {
        return fromSubSystem;
    }

    public void setFromSubSystem(String fromSubSystem) {
        this.fromSubSystem = fromSubSystem;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
}
