package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 绑定渠道的用户信息，如绑定有赞商城的用户信息
 * @author: 12869
 * @date: 2024-29-26 16:29:57
 */
public class MemberBindingReqBean {
    /**
     * 平台来源：1-妈妈100，2-快乐100，3-BNC-DTC，4-PNC-DTC，5-ANC-DTC
     */
    private Long platform;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 性别：-1-性别不详，0-男，1-女
     */
    private Long gender;

    /**
     * 姓名
     */
    private String name;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 微信appId
     */
    private String appId;

    /**
     * 微信openId
     */
    private String openId;

    /**
     * 微信unionId
     */
    private String unionId;

    /**
     * 注册时间：时间戳（毫秒）
     */
    private Long registerTime;

    /**
     * 外部会员类型：1-群脉，2-有赞
     */
    private Long externalMemberType;

    /**
     * 外部店铺id
     */
    private String externalKdtId;

    /**
     * 外部会员id
     */
    private String externalMemberId;

    /**
     * 来源系统（请找健合同事提供）
     */
    private String fromSystem;

    /**
     * 来源子系统（请找健合同事提供）
     */
    private String fromSubSystem;

    public MemberBindingReqBean(){
    }

    public MemberBindingReqBean(Long platform,String mobile,Long gender,String name,String nickName,String appId,String openId,String unionId,Long registerTime,Long externalMemberType,String externalKdtId,String externalMemberId,String fromSystem,String fromSubSystem){
        this.platform=platform;
        this.mobile=mobile;
        this.gender=gender;
        this.name=name;
        this.nickName=nickName;
        this.appId=appId;
        this.openId=openId;
        this.unionId=unionId;
        this.registerTime=registerTime;
        this.externalMemberType=externalMemberType;
        this.externalKdtId=externalKdtId;
        this.externalMemberId=externalMemberId;
        this.fromSystem=fromSystem;
        this.fromSubSystem=fromSubSystem;
    }

    public Long getPlatform() {
        return platform;
    }

    public void setPlatform(Long platform) {
        this.platform = platform;
    }
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    public Long getGender() {
        return gender;
    }

    public void setGender(Long gender) {
        this.gender = gender;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }
    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }
    public Long getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Long registerTime) {
        this.registerTime = registerTime;
    }
    public Long getExternalMemberType() {
        return externalMemberType;
    }

    public void setExternalMemberType(Long externalMemberType) {
        this.externalMemberType = externalMemberType;
    }
    public String getExternalKdtId() {
        return externalKdtId;
    }

    public void setExternalKdtId(String externalKdtId) {
        this.externalKdtId = externalKdtId;
    }
    public String getExternalMemberId() {
        return externalMemberId;
    }

    public void setExternalMemberId(String externalMemberId) {
        this.externalMemberId = externalMemberId;
    }
    public String getFromSystem() {
        return fromSystem;
    }

    public void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }
    public String getFromSubSystem() {
        return fromSubSystem;
    }

    public void setFromSubSystem(String fromSubSystem) {
        this.fromSubSystem = fromSubSystem;
    }
}
