package global.hh.openapi.sdk.api.bean.corpbasic;


/**
 * @description: 企业微信发送应用文本消息
 * @author: 12869
 * @date: 2021-26-26 09:26:32
 */
public class CorpbasicTextReqBean {
    /**
     * 自建应用id
     */
    private String agentId;

    /**
     * 消息内容，最长不超过2048个字节，超过将截断
     */
    private String content;

    /**
     * 部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数
     */
    private String toParty;

    /**
     * 成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送
     */
    private String toUser;

    public CorpbasicTextReqBean(){
    }

    public CorpbasicTextReqBean(String agentId,String content,String toParty,String toUser){
        this.agentId=agentId;
        this.content=content;
        this.toParty=toParty;
        this.toUser=toUser;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    public String getToParty() {
        return toParty;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }
    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }
}
