package global.hh.openapi.sdk.api.bean.accountservice;

        import java.util.List;

/**
 * @description: 获取人员关联的终端信息
 * @author: 23465
 * @date: 2023-42-13 21:42:07
 */
public class AccountserviceGetListReqBean {
    /**
     * 是否分页 true:分页 false:不分页 （默认true） 如果查询的数据量较大，建议采用分页;查询数据量大且不分页， 而且超过阈值(阈值根据接口查询情况进行配置)，则查询会给到异常错误信息
     */
    private Boolean paginationFlag;

    /**
     * 当前页
     */
    private Long page;

    /**
     * 是否分页 true:分页 false:不分页 （默认true） 如果查询的数据量较大，建议采用分页;查询数据量大且不分页， 而且超过阈值(阈值根据接口查询情况进行配置)，则查询会给到异常错误信息
     */
    private Long pageSize;

    /**
     * 查询方式 true:增量查询（包括新增或变更） false:范围查询 （默认true）
     */
    private Boolean incrementalFlag;

    /**
     * 增量查询开始时间 格式为：yyyy-MM-dd HH:mm:ss 针对人员与终端关系记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String startDate;

    /**
     * 增量查询结束时间 格式为：yyyy-MM-dd HH:mm:ss 针对人员与终端关系记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String endDate;

    /**
     * 查询状态 0:无效 1:当前有效（默认） 2：未来生效 3：全部
     */
    private List<Long> status;

    /**
     * 人员ID
     */
    private Long accountId;

    /**
     * 人员工号
     */
    private String code;

    public AccountserviceGetListReqBean(){
    }

    public AccountserviceGetListReqBean(Boolean paginationFlag,Long page,Long pageSize,Boolean incrementalFlag,String startDate,String endDate,List<Long> status,Long accountId,String code){
        this.paginationFlag=paginationFlag;
        this.page=page;
        this.pageSize=pageSize;
        this.incrementalFlag=incrementalFlag;
        this.startDate=startDate;
        this.endDate=endDate;
        this.status=status;
        this.accountId=accountId;
        this.code=code;
    }

    public Boolean getPaginationFlag() {
        return paginationFlag;
    }

    public void setPaginationFlag(Boolean paginationFlag) {
        this.paginationFlag = paginationFlag;
    }
    public Long getPage() {
        return page;
    }

    public void setPage(Long page) {
        this.page = page;
    }
    public Long getPageSize() {
        return pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }
    public Boolean getIncrementalFlag() {
        return incrementalFlag;
    }

    public void setIncrementalFlag(Boolean incrementalFlag) {
        this.incrementalFlag = incrementalFlag;
    }
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public List<Long> getStatus() {
        return status;
    }

    public void setStatus(List<Long> status) {
        this.status = status;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
