package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.proc.ProcCreateCmaterialOrderOpenApiReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcCreateCmaterialOrderOpenApiResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveProcOrderReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveProcOrderResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcGetWorkCodeReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcGetWorkCodeResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveMoveStockInReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveMoveStockInResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderListPdaReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderListPdaResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderFlowInfoReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderFlowInfoResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderFlowListReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderFlowListResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderInfoPdaReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryMoveStockOrderInfoPdaResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcPageAvailableStockForOpenReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcPageAvailableStockForOpenResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveMoveStockOutReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSaveMoveStockOutResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSubmitAllSerialCodeReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSubmitAllSerialCodeResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcCheckSerialCodeReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcCheckSerialCodeResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcVerifyStockExistsReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcVerifyStockExistsResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMaterialMdmPageReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMaterialMdmPageResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSupplierMdmPageReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSupplierMdmPageResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryDealerStockListReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryDealerStockListResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryReceiveListReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryReceiveListResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryPdaReceiveHistoryReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryPdaReceiveHistoryResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryPdaReceiveHistoryDetailedReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryPdaReceiveHistoryDetailedResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryReceiveDetailedReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQueryReceiveDetailedResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQuerySerialCodeDetailedReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcQuerySerialCodeDetailedResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSupplierMasterDataDetailReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcSupplierMasterDataDetailResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMaterialMasterDataDetailReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMaterialMasterDataDetailResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMasterDataIdPageReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcMasterDataIdPageResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiAddReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiAddResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcShenQingFouJueReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcShenQingFouJueResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXunReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXunResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 分销平台外部物料订单创建接口
 * @author: 23518
 * @date: 2023-50-18 10:50:11
 */
public class ProcService extends BaseService {

    public ProcService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 分销平台外部物料订单创建接口
     *
     * @author 23518
     * @createDate 2023-50-18 10:50:11
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcCreateCmaterialOrderOpenApiResBean> createCmaterialOrderOpenApi(BaseRequest<ProcCreateCmaterialOrderOpenApiReqBean> req) throws BaseException {
        return call("dealerPlatform/httpInterface/forCmaterialOrder/createCmaterialOrderOpenApi", req);
    }
    /**
    * 方法的功能描述: 分销平台外部物料订单创建接口
    *
    * @author 23518
    * @createDate 2023-50-18 10:50:11
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcCreateCmaterialOrderOpenApiResBean> createCmaterialOrderOpenApi(String url,BaseRequest<ProcCreateCmaterialOrderOpenApiReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 智采实时拉单
     *
     * @author 12804
     * @createDate 2023-37-06 13:37:35
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSaveProcOrderResBean> saveProcOrder(BaseRequest<ProcSaveProcOrderReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/saveProcOrder", req);
    }
    /**
    * 方法的功能描述: 智采实时拉单
    *
    * @author 12804
    * @createDate 2023-37-06 13:37:35
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSaveProcOrderResBean> saveProcOrder(String url,BaseRequest<ProcSaveProcOrderReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 智采商城根据token获取工号信息
     *
     * @author 12804
     * @createDate 2023-37-15 13:37:33
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcGetWorkCodeResBean> getWorkCode(BaseRequest<ProcGetWorkCodeReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/getWorkCode", req);
    }
    /**
    * 方法的功能描述: 智采商城根据token获取工号信息
    *
    * @author 12804
    * @createDate 2023-37-15 13:37:33
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcGetWorkCodeResBean> getWorkCode(String url,BaseRequest<ProcGetWorkCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-确认调入
     *
     * @author 12804
     * @createDate 2023-48-31 11:48:29
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSaveMoveStockInResBean> saveMoveStockIn(BaseRequest<ProcSaveMoveStockInReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/saveMoveStockIn", req);
    }
    /**
    * 方法的功能描述: PDA-确认调入
    *
    * @author 12804
    * @createDate 2023-48-31 11:48:29
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSaveMoveStockInResBean> saveMoveStockIn(String url,BaseRequest<ProcSaveMoveStockInReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询调仓申请单列表
     *
     * @author 12804
     * @createDate 2023-40-26 11:40:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryMoveStockOrderListPdaResBean> queryMoveStockOrderListPda(BaseRequest<ProcQueryMoveStockOrderListPdaReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryMoveStockOrderListPda", req);
    }
    /**
    * 方法的功能描述: PDA-查询调仓申请单列表
    *
    * @author 12804
    * @createDate 2023-40-26 11:40:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryMoveStockOrderListPdaResBean> queryMoveStockOrderListPda(String url,BaseRequest<ProcQueryMoveStockOrderListPdaReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-调入调出详情
     *
     * @author 12804
     * @createDate 2023-31-01 17:31:33
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryMoveStockOrderFlowInfoResBean> queryMoveStockOrderFlowInfo(BaseRequest<ProcQueryMoveStockOrderFlowInfoReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryMoveStockOrderFlowInfo", req);
    }
    /**
    * 方法的功能描述: PDA-调入调出详情
    *
    * @author 12804
    * @createDate 2023-31-01 17:31:33
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryMoveStockOrderFlowInfoResBean> queryMoveStockOrderFlowInfo(String url,BaseRequest<ProcQueryMoveStockOrderFlowInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-调入调出历史记录
     *
     * @author 12804
     * @createDate 2023-31-01 17:31:14
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryMoveStockOrderFlowListResBean> queryMoveStockOrderFlowList(BaseRequest<ProcQueryMoveStockOrderFlowListReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryMoveStockOrderFlowList", req);
    }
    /**
    * 方法的功能描述: PDA-调入调出历史记录
    *
    * @author 12804
    * @createDate 2023-31-01 17:31:14
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryMoveStockOrderFlowListResBean> queryMoveStockOrderFlowList(String url,BaseRequest<ProcQueryMoveStockOrderFlowListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询调仓单详情
     *
     * @author 12804
     * @createDate 2023-40-26 11:40:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryMoveStockOrderInfoPdaResBean> queryMoveStockOrderInfoPda(BaseRequest<ProcQueryMoveStockOrderInfoPdaReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryMoveStockOrderInfoPda", req);
    }
    /**
    * 方法的功能描述: PDA-查询调仓单详情
    *
    * @author 12804
    * @createDate 2023-40-26 11:40:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryMoveStockOrderInfoPdaResBean> queryMoveStockOrderInfoPda(String url,BaseRequest<ProcQueryMoveStockOrderInfoPdaReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 物料仓列表分页查询
     *
     * @author 12804
     * @createDate 2023-52-18 12:52:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcPageAvailableStockForOpenResBean> pageAvailableStockForOpen(BaseRequest<ProcPageAvailableStockForOpenReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/pageAvailableStockForOpen", req);
    }
    /**
    * 方法的功能描述: 物料仓列表分页查询
    *
    * @author 12804
    * @createDate 2023-52-18 12:52:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcPageAvailableStockForOpenResBean> pageAvailableStockForOpen(String url,BaseRequest<ProcPageAvailableStockForOpenReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-确认调出
     *
     * @author 12804
     * @createDate 2023-48-31 11:48:43
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSaveMoveStockOutResBean> saveMoveStockOut(BaseRequest<ProcSaveMoveStockOutReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/saveMoveStockOut", req);
    }
    /**
    * 方法的功能描述: PDA-确认调出
    *
    * @author 12804
    * @createDate 2023-48-31 11:48:43
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSaveMoveStockOutResBean> saveMoveStockOut(String url,BaseRequest<ProcSaveMoveStockOutReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-整单提交
     *
     * @author 12804
     * @createDate 2023-59-17 17:59:53
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSubmitAllSerialCodeResBean> submitAllSerialCode(BaseRequest<ProcSubmitAllSerialCodeReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/submitAllSerialCode", req);
    }
    /**
    * 方法的功能描述: PDA-整单提交
    *
    * @author 12804
    * @createDate 2023-59-17 17:59:53
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSubmitAllSerialCodeResBean> submitAllSerialCode(String url,BaseRequest<ProcSubmitAllSerialCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-条码校验接口
     *
     * @author 12804
     * @createDate 2023-46-12 11:46:35
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcCheckSerialCodeResBean> checkSerialCode(BaseRequest<ProcCheckSerialCodeReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/checkSerialCode", req);
    }
    /**
    * 方法的功能描述: PDA-条码校验接口
    *
    * @author 12804
    * @createDate 2023-46-12 11:46:35
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcCheckSerialCodeResBean> checkSerialCode(String url,BaseRequest<ProcCheckSerialCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 校验不存在的物料仓编码
     *
     * @author 23055
     * @createDate 2023-24-31 13:24:07
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcVerifyStockExistsResBean> verifyStockExists(BaseRequest<ProcVerifyStockExistsReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/verifyStockExists", req);
    }
    /**
    * 方法的功能描述: 校验不存在的物料仓编码
    *
    * @author 23055
    * @createDate 2023-24-31 13:24:07
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcVerifyStockExistsResBean> verifyStockExists(String url,BaseRequest<ProcVerifyStockExistsReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 物料主数据查询(新)
     *
     * @author 23055
     * @createDate 2023-54-26 10:54:24
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcMaterialMdmPageResBean> materialMdmPage(BaseRequest<ProcMaterialMdmPageReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/materialMdmPage", req);
    }
    /**
    * 方法的功能描述: 物料主数据查询(新)
    *
    * @author 23055
    * @createDate 2023-54-26 10:54:24
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcMaterialMdmPageResBean> materialMdmPage(String url,BaseRequest<ProcMaterialMdmPageReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 供应商主数据查询(新)
     *
     * @author 12804
     * @createDate 2023-49-26 13:49:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSupplierMdmPageResBean> supplierMdmPage(BaseRequest<ProcSupplierMdmPageReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/supplierMdmPage", req);
    }
    /**
    * 方法的功能描述: 供应商主数据查询(新)
    *
    * @author 12804
    * @createDate 2023-49-26 13:49:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSupplierMdmPageResBean> supplierMdmPage(String url,BaseRequest<ProcSupplierMdmPageReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询经销商物料仓
     *
     * @author 12804
     * @createDate 2023-28-03 10:28:18
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryDealerStockListResBean> queryDealerStockList(BaseRequest<ProcQueryDealerStockListReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryDealerStockList", req);
    }
    /**
    * 方法的功能描述: PDA-查询经销商物料仓
    *
    * @author 12804
    * @createDate 2023-28-03 10:28:18
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryDealerStockListResBean> queryDealerStockList(String url,BaseRequest<ProcQueryDealerStockListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询领用单列表
     *
     * @author 12804
     * @createDate 2023-53-04 10:53:06
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryReceiveListResBean> queryReceiveList(BaseRequest<ProcQueryReceiveListReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryReceiveList", req);
    }
    /**
    * 方法的功能描述: PDA-查询领用单列表
    *
    * @author 12804
    * @createDate 2023-53-04 10:53:06
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryReceiveListResBean> queryReceiveList(String url,BaseRequest<ProcQueryReceiveListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询领用历史列表
     *
     * @author 12804
     * @createDate 2023-59-17 17:59:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryPdaReceiveHistoryResBean> queryPdaReceiveHistory(BaseRequest<ProcQueryPdaReceiveHistoryReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryPdaReceiveHistory", req);
    }
    /**
    * 方法的功能描述: PDA-查询领用历史列表
    *
    * @author 12804
    * @createDate 2023-59-17 17:59:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryPdaReceiveHistoryResBean> queryPdaReceiveHistory(String url,BaseRequest<ProcQueryPdaReceiveHistoryReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询领用历史明细
     *
     * @author 12804
     * @createDate 2023-59-17 17:59:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryPdaReceiveHistoryDetailedResBean> queryPdaReceiveHistoryDetailed(BaseRequest<ProcQueryPdaReceiveHistoryDetailedReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryPdaReceiveHistoryDetailed", req);
    }
    /**
    * 方法的功能描述: PDA-查询领用历史明细
    *
    * @author 12804
    * @createDate 2023-59-17 17:59:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryPdaReceiveHistoryDetailedResBean> queryPdaReceiveHistoryDetailed(String url,BaseRequest<ProcQueryPdaReceiveHistoryDetailedReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询领用单明细
     *
     * @author 12804
     * @createDate 2023-17-04 14:17:56
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQueryReceiveDetailedResBean> queryReceiveDetailed(BaseRequest<ProcQueryReceiveDetailedReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/queryReceiveDetailed", req);
    }
    /**
    * 方法的功能描述: PDA-查询领用单明细
    *
    * @author 12804
    * @createDate 2023-17-04 14:17:56
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQueryReceiveDetailedResBean> queryReceiveDetailed(String url,BaseRequest<ProcQueryReceiveDetailedReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: PDA-查询领用单序列码明细
     *
     * @author 12804
     * @createDate 2023-59-17 17:59:52
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcQuerySerialCodeDetailedResBean> querySerialCodeDetailed(BaseRequest<ProcQuerySerialCodeDetailedReqBean> req) throws BaseException {
        return call("bed-smart-proc-app/pda/querySerialCodeDetailed", req);
    }
    /**
    * 方法的功能描述: PDA-查询领用单序列码明细
    *
    * @author 12804
    * @createDate 2023-59-17 17:59:52
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcQuerySerialCodeDetailedResBean> querySerialCodeDetailed(String url,BaseRequest<ProcQuerySerialCodeDetailedReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询供应商主数据明细
     *
     * @author 12804
     * @createDate 2023-34-08 16:34:35
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcSupplierMasterDataDetailResBean> supplierMasterDataDetail(BaseRequest<ProcSupplierMasterDataDetailReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/supplierMasterDataDetail", req);
    }
    /**
    * 方法的功能描述: 查询供应商主数据明细
    *
    * @author 12804
    * @createDate 2023-34-08 16:34:35
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcSupplierMasterDataDetailResBean> supplierMasterDataDetail(String url,BaseRequest<ProcSupplierMasterDataDetailReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询物料主数据明细
     *
     * @author 12804
     * @createDate 2023-34-08 16:34:35
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcMaterialMasterDataDetailResBean> materialMasterDataDetail(BaseRequest<ProcMaterialMasterDataDetailReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/materialMasterDataDetail", req);
    }
    /**
    * 方法的功能描述: 查询物料主数据明细
    *
    * @author 12804
    * @createDate 2023-34-08 16:34:35
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcMaterialMasterDataDetailResBean> materialMasterDataDetail(String url,BaseRequest<ProcMaterialMasterDataDetailReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 主数据ID查询
     *
     * @author 12804
     * @createDate 2023-18-10 09:18:17
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcMasterDataIdPageResBean> masterDataIdPage(BaseRequest<ProcMasterDataIdPageReqBean> req) throws BaseException {
        return call("bed-smart-proc-service/openApi/masterDataIdPage", req);
    }
    /**
    * 方法的功能描述: 主数据ID查询
    *
    * @author 12804
    * @createDate 2023-18-10 09:18:17
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcMasterDataIdPageResBean> masterDataIdPage(String url,BaseRequest<ProcMasterDataIdPageReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: TPM申请单反馈接口
     *
     * @author 21506
     * @createDate 2023-14-30 11:14:04
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcHeTongFanKuiAddResBean> heTongFanKuiAdd(BaseRequest<ProcHeTongFanKuiAddReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/heTongFanKuiAdd", req);
    }
    /**
    * 方法的功能描述: TPM申请单反馈接口
    *
    * @author 21506
    * @createDate 2023-14-30 11:14:04
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcHeTongFanKuiAddResBean> heTongFanKuiAdd(String url,BaseRequest<ProcHeTongFanKuiAddReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: TPM申请单否决接口
     *
     * @author 21506
     * @createDate 2023-20-30 20:20:39
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcShenQingFouJueResBean> shenQingFouJue(BaseRequest<ProcShenQingFouJueReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/shenQingFouJue", req);
    }
    /**
    * 方法的功能描述: TPM申请单否决接口
    *
    * @author 21506
    * @createDate 2023-20-30 20:20:39
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcShenQingFouJueResBean> shenQingFouJue(String url,BaseRequest<ProcShenQingFouJueReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: TPM预算池查询
     *
     * @author 21506
     * @createDate 2023-28-30 16:28:42
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcF29ChaXunResBean> f29ChaXun(BaseRequest<ProcF29ChaXunReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/f29ChaXun", req);
    }
    /**
    * 方法的功能描述: TPM预算池查询
    *
    * @author 21506
    * @createDate 2023-28-30 16:28:42
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcF29ChaXunResBean> f29ChaXun(String url,BaseRequest<ProcF29ChaXunReqBean> req) throws BaseException {
         return call(url, req);
    }


}
