package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.multiwechatdealer.MultiwechatdealerGetOpenTerminalAddressInfoListReqBean;
import global.hh.openapi.sdk.api.bean.multiwechatdealer.MultiwechatdealerGetOpenTerminalAddressInfoListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 获取终端的兑换地址
 * @author: 777771
 * @date: 2023-53-17 12:53:29
 */
public class MultiWechatDealerService extends BaseService {

    public MultiWechatDealerService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 获取终端的兑换地址
     *
     * @author 777771
     * @createDate 2023-53-17 12:53:29
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MultiwechatdealerGetOpenTerminalAddressInfoListResBean> getOpenTerminalAddressInfoList(BaseRequest<MultiwechatdealerGetOpenTerminalAddressInfoListReqBean> req) throws BaseException {
        return call("multi-wechat-dealer/terminal/openTerminal/getOpenTerminalAddressInfoList", req);
    }
    /**
    * 方法的功能描述: 获取终端的兑换地址
    *
    * @author 777771
    * @createDate 2023-53-17 12:53:29
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MultiwechatdealerGetOpenTerminalAddressInfoListResBean> getOpenTerminalAddressInfoList(String url,BaseRequest<MultiwechatdealerGetOpenTerminalAddressInfoListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
