package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCallbackReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCallbackResBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCodeListReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCodeListResBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceListReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceListResBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceTemplateListReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceTemplateListResBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceExtReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceExtResBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCategoryListReqBean;
import global.hh.openapi.sdk.api.bean.bedmdmservice.BedmdmserviceCategoryListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: netsuit回调mdm更新productReferenceNumber
 * @author: 24457
 * @date: 2023-40-08 16:40:26
 */
public class BedMdmServiceService extends BaseService {

    public BedMdmServiceService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: netsuit回调mdm更新productReferenceNumber
     *
     * @author 24457
     * @createDate 2023-40-08 16:40:26
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceCallbackResBean> callback(BaseRequest<BedmdmserviceCallbackReqBean> req) throws BaseException {
        return call("bed-mdm-service/product/netsuit/callback", req);
    }
    /**
    * 方法的功能描述: netsuit回调mdm更新productReferenceNumber
    *
    * @author 24457
    * @createDate 2023-40-08 16:40:26
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceCallbackResBean> callback(String url,BaseRequest<BedmdmserviceCallbackReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询MDM产品码表信息接口
     *
     * @author 12869
     * @createDate 2023-15-01 17:15:15
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceCodeListResBean> codeList(BaseRequest<BedmdmserviceCodeListReqBean> req) throws BaseException {
        return call("bed-mdm-service/product/code/list", req);
    }
    /**
    * 方法的功能描述: 查询MDM产品码表信息接口
    *
    * @author 12869
    * @createDate 2023-15-01 17:15:15
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceCodeListResBean> codeList(String url,BaseRequest<BedmdmserviceCodeListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询MDM产品信息接口
     *
     * @author 12869
     * @createDate 2023-07-15 14:07:49
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceListResBean> list(BaseRequest<BedmdmserviceListReqBean> req) throws BaseException {
        return call("bed-mdm-service/product/list", req);
    }
    /**
    * 方法的功能描述: 查询MDM产品信息接口
    *
    * @author 12869
    * @createDate 2023-07-15 14:07:49
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceListResBean> list(String url,BaseRequest<BedmdmserviceListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询MDM映射信息接口
     *
     * @author 12869
     * @createDate 2023-15-01 17:15:15
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceTemplateListResBean> templateList(BaseRequest<BedmdmserviceTemplateListReqBean> req) throws BaseException {
        return call("bed-mdm-service/mapping/template/list", req);
    }
    /**
    * 方法的功能描述: 查询MDM映射信息接口
    *
    * @author 12869
    * @createDate 2023-15-01 17:15:15
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceTemplateListResBean> templateList(String url,BaseRequest<BedmdmserviceTemplateListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询MDM产品信息接口(拓展)
     *
     * @author 24457
     * @createDate 2023-14-15 10:14:28
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceExtResBean> ext(BaseRequest<BedmdmserviceExtReqBean> req) throws BaseException {
        return call("bed-mdm-service/product/list/ext", req);
    }
    /**
    * 方法的功能描述: 查询MDM产品信息接口(拓展)
    *
    * @author 24457
    * @createDate 2023-14-15 10:14:28
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceExtResBean> ext(String url,BaseRequest<BedmdmserviceExtReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询MDM产品品类信息接口
     *
     * @author 12869
     * @createDate 2023-15-01 17:15:15
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<BedmdmserviceCategoryListResBean> categoryList(BaseRequest<BedmdmserviceCategoryListReqBean> req) throws BaseException {
        return call("bed-mdm-service/product/category/list", req);
    }
    /**
    * 方法的功能描述: 查询MDM产品品类信息接口
    *
    * @author 12869
    * @createDate 2023-15-01 17:15:15
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<BedmdmserviceCategoryListResBean> categoryList(String url,BaseRequest<BedmdmserviceCategoryListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
