package global.hh.openapi.sdk.api.bean.terminal;

        import java.util.List;
        import java.util.List;

/**
 * @description: 获取终端的详细信息
 * @author: 23465
 * @date: 2023-42-13 21:42:11
 */
public class TerminalGetSimpleListReqBean {
    /**
     * 是否增量 true:增量 false:全量 （默认true）
     */
    private Boolean incrementalFlag;

    /**
     * 开始时间 格式为：yyyy-MM-dd hh24:mi:ss
     */
    private String startDate;

    /**
     * 结束时间 格式为：yyyy-MM-dd hh24:mi:ss
     */
    private String endDate;

    /**
     * 是否分页 true:分页 false:不分页 （默认true）
     */
    private Boolean paginationFlags;

    /**
     * 当前页
     */
    private Long page;

    /**
     * 每页条数(默认20条)
     */
    private Long pageSize;

    /**
     * 是否展示终端业务属性 true:是 false:否 （默认false）
     */
    private Boolean attributeFlags;

    /**
     * 潜店)终端名称
     */
    private String terminalName;

    /**
     * 潜店)终端编码
     */
    private String terminalCode;

    /**
     * 批量终端编码(单个和批量只能二选一)
     */
    private List<String> codeArray;

    /**
     * (潜店传关于潜店的状态)终端状态:01 正常、02 撤销、03 测试、04 冻结、06 潜店、07 潜店转正常、08 潜店撤销 如果为空就显示全部状态终端
     */
    private List<String> status;

    /**
     * 关联的门店业务类型（现在有正式门店和潜在门店） formal:正式门店查询（默认） potential:潜在门店查询
     */
    private String terminalBusinessType;

    /**
     * 终端类型:1 直营、2 加盟、3 个体、4 区域连锁、5 全国连锁、6 虚拟终端
     */
    private String terminalType;

    /**
     * 事业部编码
     */
    private String businessDepartmentCode;

    /**
     * 办事处编码
     */
    private String officeCode;

    /**
     * (潜店)业务渠道编码:01 婴线、02 商超、03 药线、04 电商、08 SA、13 美妆、14 宠物店、15 宠物医院、19 繁育
     */
    private String bizChannelCode;

    /**
     * (潜店)管理渠道编码:01 婴线、02 商超、03 药线、04 电商、08 SA、13 美妆、14 宠物店、15 宠物医院、19 繁育
     */
    private String mgrChannelCode;

    public TerminalGetSimpleListReqBean(){
    }

    public TerminalGetSimpleListReqBean(Boolean incrementalFlag,String startDate,String endDate,Boolean paginationFlags,Long page,Long pageSize,Boolean attributeFlags,String terminalName,String terminalCode,List<String> codeArray,List<String> status,String terminalBusinessType,String terminalType,String businessDepartmentCode,String officeCode,String bizChannelCode,String mgrChannelCode){
        this.incrementalFlag=incrementalFlag;
        this.startDate=startDate;
        this.endDate=endDate;
        this.paginationFlags=paginationFlags;
        this.page=page;
        this.pageSize=pageSize;
        this.attributeFlags=attributeFlags;
        this.terminalName=terminalName;
        this.terminalCode=terminalCode;
        this.codeArray=codeArray;
        this.status=status;
        this.terminalBusinessType=terminalBusinessType;
        this.terminalType=terminalType;
        this.businessDepartmentCode=businessDepartmentCode;
        this.officeCode=officeCode;
        this.bizChannelCode=bizChannelCode;
        this.mgrChannelCode=mgrChannelCode;
    }

    public Boolean getIncrementalFlag() {
        return incrementalFlag;
    }

    public void setIncrementalFlag(Boolean incrementalFlag) {
        this.incrementalFlag = incrementalFlag;
    }
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public Boolean getPaginationFlags() {
        return paginationFlags;
    }

    public void setPaginationFlags(Boolean paginationFlags) {
        this.paginationFlags = paginationFlags;
    }
    public Long getPage() {
        return page;
    }

    public void setPage(Long page) {
        this.page = page;
    }
    public Long getPageSize() {
        return pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }
    public Boolean getAttributeFlags() {
        return attributeFlags;
    }

    public void setAttributeFlags(Boolean attributeFlags) {
        this.attributeFlags = attributeFlags;
    }
    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }
    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }
    public List<String> getCodeArray() {
        return codeArray;
    }

    public void setCodeArray(List<String> codeArray) {
        this.codeArray = codeArray;
    }
    public List<String> getStatus() {
        return status;
    }

    public void setStatus(List<String> status) {
        this.status = status;
    }
    public String getTerminalBusinessType() {
        return terminalBusinessType;
    }

    public void setTerminalBusinessType(String terminalBusinessType) {
        this.terminalBusinessType = terminalBusinessType;
    }
    public String getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }
    public String getBusinessDepartmentCode() {
        return businessDepartmentCode;
    }

    public void setBusinessDepartmentCode(String businessDepartmentCode) {
        this.businessDepartmentCode = businessDepartmentCode;
    }
    public String getOfficeCode() {
        return officeCode;
    }

    public void setOfficeCode(String officeCode) {
        this.officeCode = officeCode;
    }
    public String getBizChannelCode() {
        return bizChannelCode;
    }

    public void setBizChannelCode(String bizChannelCode) {
        this.bizChannelCode = bizChannelCode;
    }
    public String getMgrChannelCode() {
        return mgrChannelCode;
    }

    public void setMgrChannelCode(String mgrChannelCode) {
        this.mgrChannelCode = mgrChannelCode;
    }
}
