package global.hh.openapi.sdk.api.bean.merchant;


/**
 * @description: 推送消息到营销通APP客户端的系统通知栏目，提醒用户有消息到来
 * @author: 3742
 * @date: 2018-46-15 17:46:49
 */
public class MerchantSendSystemMessageReqBean {
    /**
     * 营销通app token，accountId与yxtAppToken不能同时查
     */
    private String yxtAppToken;

    /**
     * 营销通app 登录人 ID，accountId与yxtAppToken不能同时查
     */
    private Long accountId;

    /**
     * 消息标题，为空使用默认标题
     */
    private String title;

    /**
     * 推送的消息内容
     */
    private String message;

    public MerchantSendSystemMessageReqBean(){
    }

    public MerchantSendSystemMessageReqBean(String yxtAppToken,Long accountId,String title,String message){
        this.yxtAppToken=yxtAppToken;
        this.accountId=accountId;
        this.title=title;
        this.message=message;
    }

    public String getYxtAppToken() {
        return yxtAppToken;
    }

    public void setYxtAppToken(String yxtAppToken) {
        this.yxtAppToken = yxtAppToken;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
