package global.hh.openapi.sdk.api.bean.merchant;


/**
 * @description: 根据营销通app token或账号ID
查询登录人的账号基础信息，包含当前登录人所在的大区办事处。

角色类型定义如下：
1	合生元
2	长沙素加
3	Swisse人员
7	店主
8	店长
9	店员
10	综合促销员
11	KOL
12	Feichat
14	Swisse促销员
15	促销教练
38	微客
40	大区药线商务推广员
41	SA育婴顾问
42	品牌大使
43	商超特工
44	经销商业务员
45	业务精英
50	BNC活动精英
51	ANC活动精英
52	联营人员
 * @author: 3742
 * @date: 2018-45-07 11:45:03
 */
public class MerchantQueryAccountInfoResBean {

        /**
         * 操作员工号
         */
        private String accountNo;

        /**
         * 用户ID
         */
        private Number accountId;

        /**
         * 总部编号
         */
        private String headquarterCode;

        /**
         * 总部名称
         */
        private String headquarterName;

        /**
         * 大区编号
         */
        private String areaCode;

        /**
         * 大区名称
         */
        private String areaName;

        /**
         * 操作员手机号码
         */
        private String mobile;

        /**
         * 操作员名称
         */
        private String name;

        /**
         * 办事处编号
         */
        private String officeCode;

        /**
         * 办事处名称
         */
        private String officeName;

        /**
         * 人员层级,1：总部， 3：大区，4：办事处，0：门店、促销员、育婴顾问等无公司组织架构人员
         */
        private Number tier;

        /**
         * 操作员角色列表
         */
        private Object[] roles;

        /**
         * 门店编号
         */
        private String terminalCode;

        /**
         * 门店名称
         */
        private String terminalName;

    public MerchantQueryAccountInfoResBean(){
    }

    public MerchantQueryAccountInfoResBean(String accountNo,Number accountId,String headquarterCode,String headquarterName,String areaCode,String areaName,String mobile,String name,String officeCode,String officeName,Number tier,Object[] roles,String terminalCode,String terminalName){
        this.accountNo=accountNo;
        this.accountId=accountId;
        this.headquarterCode=headquarterCode;
        this.headquarterName=headquarterName;
        this.areaCode=areaCode;
        this.areaName=areaName;
        this.mobile=mobile;
        this.name=name;
        this.officeCode=officeCode;
        this.officeName=officeName;
        this.tier=tier;
        this.roles=roles;
        this.terminalCode=terminalCode;
        this.terminalName=terminalName;
    }

    public String getAccountNo() {
        return accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }
    public Number getAccountId() {
        return accountId;
    }

    public void setAccountId(Number accountId) {
        this.accountId = accountId;
    }
    public String getHeadquarterCode() {
        return headquarterCode;
    }

    public void setHeadquarterCode(String headquarterCode) {
        this.headquarterCode = headquarterCode;
    }
    public String getHeadquarterName() {
        return headquarterName;
    }

    public void setHeadquarterName(String headquarterName) {
        this.headquarterName = headquarterName;
    }
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getOfficeCode() {
        return officeCode;
    }

    public void setOfficeCode(String officeCode) {
        this.officeCode = officeCode;
    }
    public String getOfficeName() {
        return officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }
    public Number getTier() {
        return tier;
    }

    public void setTier(Number tier) {
        this.tier = tier;
    }
    public Object[] getRoles() {
        return roles;
    }

    public void setRoles(Object[] roles) {
        this.roles = roles;
    }
    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }
    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }
}
