package global.hh.openapi.sdk.api.bean.hcm;


/**
 * @description: 获取组织架构信息
 * @author: 777771
 * @date: 2023-33-30 20:33:46
 */
public class HcmGetDepartmentListReqBean {
    /**
     * 是否增量,增量查询一定要传开始.结束时间
     */
    private String incrementalFlag;

    /**
     * 根据部门编码查询
     */
    private String code;

    /**
     * 增量查询开始时间 格式为：yyyy-MM-dd 针对人员记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String startDate;

    /**
     * 增量查询结束时间 格式为：yyyy-MM-dd 针对人员记录创建时间或更新时间,如果选择了增量查询方式需要必传，范围查询会忽略此条件
     */
    private String endDate;

    /**
     * 根据部门名称查询
     */
    private String name;

    /**
     * 根据人员状态查询 状态 1：有效 2：无效 (注：不传或空为全部 )
     */
    private String status;

    /**
     * 是否获取指定部门下的子部门，是对部门编码条件的补充。 true:获取，false:不获取，默认情况下不获取
     */
    private String lowerLevelFlag;

    public HcmGetDepartmentListReqBean(){
    }

    public HcmGetDepartmentListReqBean(String incrementalFlag,String code,String startDate,String endDate,String name,String status,String lowerLevelFlag){
        this.incrementalFlag=incrementalFlag;
        this.code=code;
        this.startDate=startDate;
        this.endDate=endDate;
        this.name=name;
        this.status=status;
        this.lowerLevelFlag=lowerLevelFlag;
    }

    public String getIncrementalFlag() {
        return incrementalFlag;
    }

    public void setIncrementalFlag(String incrementalFlag) {
        this.incrementalFlag = incrementalFlag;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public String getLowerLevelFlag() {
        return lowerLevelFlag;
    }

    public void setLowerLevelFlag(String lowerLevelFlag) {
        this.lowerLevelFlag = lowerLevelFlag;
    }
}
