package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXun2ReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXun2ResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXunReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcF29ChaXunResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiaddReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiaddResBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiaddActionReqBean;
import global.hh.openapi.sdk.api.bean.proc.ProcHeTongFanKuiaddActionResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 预算池查询2
 * @author: 777771
 * @date: 2023-42-30 16:42:40
 */
public class ProcService extends BaseService {

    public ProcService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 预算池查询2
     *
     * @author 777771
     * @createDate 2023-42-30 16:42:40
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcF29ChaXun2ResBean> F29ChaXun2(BaseRequest<ProcF29ChaXun2ReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/F29ChaXun2", req);
    }
    /**
    * 方法的功能描述: 预算池查询2
    *
    * @author 777771
    * @createDate 2023-42-30 16:42:40
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcF29ChaXun2ResBean> F29ChaXun2(String url,BaseRequest<ProcF29ChaXun2ReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 预算池查询
     *
     * @author 777771
     * @createDate 2023-27-30 16:27:31
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcF29ChaXunResBean> F29ChaXun(BaseRequest<ProcF29ChaXunReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/F29ChaXun", req);
    }
    /**
    * 方法的功能描述: 预算池查询
    *
    * @author 777771
    * @createDate 2023-27-30 16:27:31
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcF29ChaXunResBean> F29ChaXun(String url,BaseRequest<ProcF29ChaXunReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 申请单反馈接口
     *
     * @author 777771
     * @createDate 2023-40-30 14:40:02
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcHeTongFanKuiaddResBean> heTongFanKuiadd(BaseRequest<ProcHeTongFanKuiaddReqBean> req) throws BaseException {
        return call("bed-tpm-service/tpm/heTongFanKui-add", req);
    }
    /**
    * 方法的功能描述: 申请单反馈接口
    *
    * @author 777771
    * @createDate 2023-40-30 14:40:02
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcHeTongFanKuiaddResBean> heTongFanKuiadd(String url,BaseRequest<ProcHeTongFanKuiaddReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: TPM申请单反馈接口
     *
     * @author 777771
     * @createDate 2023-00-30 14:00:01
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<ProcHeTongFanKuiaddActionResBean> heTongFanKuiaddAction(BaseRequest<ProcHeTongFanKuiaddActionReqBean> req) throws BaseException {
        return call("xiaolutong/api/tpmApi/heTongFanKui-add.action", req);
    }
    /**
    * 方法的功能描述: TPM申请单反馈接口
    *
    * @author 777771
    * @createDate 2023-00-30 14:00:01
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<ProcHeTongFanKuiaddActionResBean> heTongFanKuiaddAction(String url,BaseRequest<ProcHeTongFanKuiaddActionReqBean> req) throws BaseException {
         return call(url, req);
    }


}
